<?php

class ClaimnumbergenerationController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
		//	'accessControl', // perform access control for CRUD operations
		//	'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Claimnumbergeneration;
                $user=User::model()->findByPk(Yii::app()->user->id);
                $cmp_id=$user->branch->company->id;
                $format=Format::model()->findAll();
                $q=new CDbCriteria;
                $q->compare('t.company_id',$cmp_id);
                $m=$model->find($q);
                if($m!=null)
                  $this->redirect(array('update','id'=>$m->id));
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                //var_dump($format);
		if(isset($_POST['Claimnumbergeneration']))
		{
			$model->attributes=$_POST['Claimnumbergeneration'];
                        $model->company_id=$cmp_id;
                        $model->created_by=Yii::app()->user->id;
			if($model->save())
				 Yii::app()->user->setFlash('success','Claim Number generation is set');
                         
		}

		$this->render('create',array(
			'model'=>$model,
                        'format'=>$format,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                $user=User::model()->findByPk(Yii::app()->user->id);
                $cmp_id=$user->branch->company->id;
                $format=Format::model()->findAll();
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimnumbergeneration']))
		{
			$model->attributes=$_POST['Claimnumbergeneration'];
                        $model->created_by=Yii::app()->user->id;
			if($model->save())
				 Yii::app()->user->setFlash('success','Claim Number generation is set');
                         
		}

		$this->render('update',array(
			'model'=>$model,
                        'format'=>$format,
		));
	}
        public function actionSavemethod()
        {
            $model=new Format;
            $model->method=$_POST['method'];
            $model->created_by=Yii::app()->user->id;
           if($model->save())
              echo '<div class="flash-success"> is save but we need to implement it</div>';
           $err=$model->getErrors();
           foreach ($err as $e)
           {               foreach ($e as $r) 
               echo '<div class="flash-success">'.$r.'</div>';}
        }

        /**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimnumbergeneration');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimnumbergeneration('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimnumbergeneration']))
			$model->attributes=$_GET['Claimnumbergeneration'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimnumbergeneration the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimnumbergeneration::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimnumbergeneration $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimnumbergeneration-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
