<?php

class CfssupportController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
public function actionComplaint()
	{
		$model=new Cfssupport;
		//public function letsMail($to = 'neetuverma26@gmail.com', $cc = 'dhimandee@gmail.com', $from = 'noreply@claimflowsolutions.com', $subject='New Email Notiication from Claimflow Solutions LLC',$priority = 3, $message='Test Message')
		
		$validationParams = array('Cfssupport[suggestions]','Cfssupport[dateofissue]', 'Cfssupport[issue],Cfssupport[name]');
                
            if(isset($_POST['Cfssupport']))
		{
                     if ($model->validate($validationParams)  )
                     {
			
			if(isset($_POST['Cfssupport']['name'])){
				$message .= '<p><b style="float:left;width:150px;">Name :</b>'.$_POST['Cfssupport']['name'].'</p>';
			}
			if(isset($_POST['Cfssupport']['issue'])){
				$message .= '<p><b style="float:left;width:150px;">Contact Information :</b>'.$_POST['Cfssupport']['contact_information'].'</p>';
			}
			if(isset($_POST['Cfssupport']['suggestions'])){
				$message .= '<p><b style="float:left;width:150px;">Message :</b>'.$_POST['Cfssupport']['message'].'</p>';
			}
			     //
				$this->letsMail('SUPPORT@CLAIMSFLOWSOLUTIONS.com','TEST@CLAIMSFLOWSOLUTIONS.com','noreply@claimflowsolutions.com','New Email Notiication from Claimflow Solutions LLC',3,$message);
			
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
                }  
		$this->render('complaint',array(
			'model'=>$model,
		));
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Cfssupport;
		//public function letsMail($to = 'neetuverma26@gmail.com', $cc = 'dhimandee@gmail.com', $from = 'noreply@claimflowsolutions.com', $subject='New Email Notiication from Claimflow Solutions LLC',$priority = 3, $message='Test Message')
		
		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);
                    if(!isset($_POST['ajax']))
                    {
		if(isset($_POST['Cfssupport']))
		{
			$model->attributes=$_POST['Cfssupport'];
			$message = '';
			if(isset($_POST['Cfssupport']['importance'])){
				$message .= '<p><b style="float:left;width:150px;">Importance :</b>'.$_POST['Cfssupport']['importance'].'</p>';
			}
			if(isset($_POST['Cfssupport']['contact_type'])){
				$message .= '<p><b style="float:left;width:150px;">Contact Type :</b>'.$_POST['Cfssupport']['contact_type'].'</p>';
			}
			if(isset($_POST['Cfssupport']['name'])){
				$message .= '<p><b style="float:left;width:150px;">Name :</b>'.$_POST['Cfssupport']['name'].'</p>';
			}
			if(isset($_POST['Cfssupport']['contact_information'])){
				$message .= '<p><b style="float:left;width:150px;">Contact Information :</b>'.$_POST['Cfssupport']['contact_information'].'</p>';
			}
			if(isset($_POST['Cfssupport']['message'])){
				$message .= '<p><b style="float:left;width:150px;">Message :</b>'.$_POST['Cfssupport']['message'].'</p>';
			}
			if($_POST['Cfssupport']['importance'] == 'High'){
                            //
				$this->letsMail('admin@claimsflowsolutions.com','TEST@CLAIMSFLOWSOLUTIONS.com','noreply@claimflowsolutions.com','New Email Notiication from Claimflow Solutions LLC',3,$message);
			}else{
                                    $this->letsMail('admin@claimsflowsolutions.com','TEST@CLAIMSFLOWSOLUTIONS.com','noreply@claimflowsolutions.com','New Email Notiication from Claimflow Solutions LLC',1,$message);
			}
			if($model->save())
			{	//$this->redirect(array('view','id'=>$model->id));
                            Yii::app()->user->setFlash('success','Your Message has been sent successfully');
                         
                           
                        }
		}
                    }
		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Cfssupport']))
		{
			$model->attributes=$_POST['Cfssupport'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Cfssupport');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Cfssupport('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Cfssupport']))
			$model->attributes=$_GET['Cfssupport'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Cfssupport the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Cfssupport::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Cfssupport $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='cfssupport-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
