<?php



class CaseController extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */

	public $layout='//layouts/column2',$ad=0;



	/**

	 * @return array action filters

	 */

	public function filters()

	{

		return array(

			//'accessControl', // perform access control for CRUD operations

			//'postOnly + delete', // we only allow deletion via POST request

			'rights',

		);

	}

	public function allowedActions()
	{
		return 'getcas,getlays,getcasegr';
	}

	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()

	{

		return array(

			//array('allow',  // allow all users to perform 'index' and 'view' actions

				//'actions'=>array('index','view'),

				//'users'=>array('*'),

			//),

			//array('allow', // allow authenticated user to perform 'create' and 'update' actions

				//'actions'=>array('create','update'),

				//'users'=>array('@'),

			//),

			array('deny',  // deny all users

				'users'=>array('*'),

			),

			array('allow', // allow admin user to perform 'admin' and 'delete' actions

				'actions'=>array('admin','delete'),

				'users'=>array('admin'),

			),

			array('deny',  // deny all users

				'users'=>array('*'),

			),

		);

	}

	public function actionVername()
	{
		$str = $_REQUEST['q'];
		$str = str_replace('_','',$str);
		$str = str_replace('(','',$str);
		$str = str_replace(')','',$str);
		$str = str_replace(' vs ','',$str);
		if(count($str)>=1 && !empty($str)){
			echo 'true';
		}else{
			echo 'false';
		}
		Yii::app()->end();
	}
	
	public function actionGetcas(){
		$this->dbswitch(Yii::app()->user->firm_id); 
		$cas = new Cases;
		$c= new CDbCriteria;
		$c->join = 'left join client c on c.id = t.user_id left join users u on u.id = c.user_id';
		$c->compare('u.id',$_REQUEST['q']);
		$cases = $cas->findAll($c);
		$dat = '';$f=0;
		foreach($cases as $ca){
			$dat[$f]['id'] = $ca->id;
			$dat[$f]['name'] = $ca->case_no;
			$f++;
		}
		echo json_encode($dat);
	}
	
	public function actionGetlays(){
		$this->dbswitch(Yii::app()->user->firm_id); 
		$cas = new User;
		$c= new CDbCriteria;
		$c->join = 'left join case_user cu on cu.user_id = t.id left join cases c on c.id = cu.case_id';
		$c->compare('c.id',$_REQUEST['q']);
		$cases = $cas->findAll($c);
		$dat = '';$f=0;
		foreach($cases as $ca){
			$dat[$f]['id'] = $ca->id;
			$dat[$f]['name'] = $ca->profile->fullname;
			$f++;
		}
		echo json_encode($dat);
	}

	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */

	public function actionView($id)

	{
                $this->layout = 'logged';
				$cits=new Cits;
				$iits=new Iits;
				$q = new CDbCriteria;
           // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('t.case_id',$id);
            $cit = $cits->findAll($q);
			
			$q = new CDbCriteria;
           // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('t.case_id',$id);
            $iit = $iits->findAll($q); 
			//var_dump($_SESSION['client']); die();
			$ocei=new Ocei;
			$q = new CDbCriteria;
			$q->join = "left join user on user.id=t.client_id";
			$q->compare('user.id',$_SESSION['client']);
			$oceidata=$ocei->find($q);
			
			$ocedi=new Ocedi;
			$q = new CDbCriteria;
			$q->compare('t.client_id',$_SESSION['client']);
			$ocedidata=$ocedi->find($q);
		$ocapf=new Ocapf;
			$q = new CDbCriteria;
			$q->compare('t.user_id',$_SESSION['client']);
			$ocapfdata=$ocapf->find($q);
			
		$this->render('view',array(
		
			
			
			
			'model'=>$this->loadModel($id),
			'cit'=>$cit,
			'iit'=>$iit,
			'oceidata'=>$oceidata,
			'ocedidata'=>$ocedidata,
			'ocapfdata'=>$ocapfdata,
		));

	}
        
        public function actionViewi($id)

	{
            $this->layout = 'logged';
            $cinv = new Cinvoice;
            $cits=new Cits;
            $iits=new Iits;
            $q = new CDbCriteria;
            // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('id',$id);
            $cit = $cinv->find($q);
			
            $q = new CDbCriteria;
            // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('t.case_id',$id);
            $iit = $iits->findAll($q); 
		$this->render('viewi',array(			
			'model'=>$cit,			
		));

	}
        
        public function actionContract($cd = null){
            $this->layout ="logged";
            $model = new Casecontract;
            if(isset($_POST['Casecontract']) && !Yii::app()->request->isAjaxRequest){
                $model->attributes = $_POST['Casecontract'];
                $model->save();
                $this->redirect(array('admin'));
            }
            $this->render('contract',array('model'=>$model,'case_id'=>$cd));
        }
        
        public function actionCriminallaw($cd = null){
            $this->layout ="logged";
            $model = new Criminallaw;
            if(isset($_POST['Criminallaw']) && !Yii::app()->request->isAjaxRequest){
                $model->attributes = $_POST['Criminallaw'];
                $model->save();
                $this->redirect(array('admin'));
            }
            $this->render('criminallaw',array('model'=>$model,'case_id'=>$cd));
        }
        
        public function actionImigration($cd = null){
            $this->layout ="logged";
            $model = new Imigrationinfo;
            if(isset($_POST['Imigrationinfo']) && !Yii::app()->request->isAjaxRequest){
                $model->attributes = $_POST['Imigrationinfo'];
                $model->save();
                $this->redirect(array('admin'));
            }
            $this->render('imigration',array('model'=>$model,'case_id'=>$cd));
        }
       
        public function actionRealestate($cd = null){
            $this->layout ="logged";
            $model = new Realestateinfo;
            $bsba = new Bsbainfo;            
            if(isset($_POST['Realestateinfo']) && !Yii::app()->request->isAjaxRequest){                
                $model->attributes = $_POST['Realestateinfo'];
                $model->save();
                $r_id = $model->primaryKey;                
                if(isset($_POST['Bsbainfo'])){
                    $bsba->attributes = $_POST['Bsbainfo'];
                    $bsba->realestateinfo_id = $r_id;
                    $bsba->save();
                }
                $this->redirect(array('admin'));
            }
            $this->render('realestate',array('model'=>$model,'case_id'=>$cd,'bsba'=>$bsba));
        }
        
        public function actionWorker($cd = null){
            $this->layout ="logged";
            $model = new Workercomp;
            $injury = new Injuryinfo;
            $empinfo = new Empinfo;
            $wcicf = new Wcicf;
            $mspi = new Mspi;
            if(isset($_POST['Workercomp']) && !Yii::app()->request->isAjaxRequest){     
                //var_dump($_POST);
               // die();
                $model->attributes = $_POST['Workercomp'];
                $model->save();
                $wc_id = $model->primaryKey;
                
                if(isset($_POST['Mspi'])){
                    foreach($_POST['Mspi'] as $ci){
                        $child = new Mspi;
                        $child->attributes = $ci;
                        $child->workercomp_id = $wc_id;
                        $child->save();
                    }
                }
                if(isset($_POST['Injuryinfo'])){            
                    $injury->attributes = $_POST['Injuryinfo'];
                    $injury->workercomp_id = $wc_id;
                    $injury->save();            
                }
                
                if(isset($_POST['Empinfo'])){
                    $empinfo->attributes = $_POST['Empinfo'];
                    $empinfo->workercomp_id = $wc_id;
                    $empinfo->save();
                }
                if(isset($_POST['Wcicf'])){
                    $wcicf->attributes = $_POST['Wcicf'];
                    $wcicf->workercomp_id = $wc_id;
                    $wcicf->save();
                }
                $this->redirect(array('admin'));
            }
            $this->render('worker',array('model'=>$model,'case_id'=>$cd,'emp'=>$empinfo,'injury'=>$injury,'wcicf'=>$wcicf,'mspi'=>$mspi));
        }
        
        public function actionTrustwill($cd = null){
            $this->layout ="logged";
            $model = new Trustwill;
            $trusta = new Trusta;
            $trustb = new Trustb;
            $testator = new Testator;
            $executor = new Executor;
            if(isset($_POST['Trustwill']) && !Yii::app()->request->isAjaxRequest){     
                //var_dump($_POST);
               // die();
                $model->attributes = $_POST['Trustwill'];
                $model->save();
                $tw_id = $model->primaryKey;
                
                if(isset($_POST['Trusta'])){
                    foreach($_POST['Trusta'] as $ci){
                        $child = new Trusta();
                        $child->attributes = $ci;
                        $child->trustwill_id = $tw_id;
                        $child->save();
                    }
                }
                if(isset($_POST['Trustb'])){
                    foreach($_POST['Trustb'] as $ci){
                        $child = new Trustb();
                        $child->attributes = $ci;
                        $child->trustwill_id = $tw_id;
                        $child->save();
                    }
                }
                
                if(isset($_POST['Testator'])){
                    $testator->attributes = $_POST['Testator'];
                    $testator->trustwill_id = $tw_id;
                    $testator->save();
                }
                if(isset($_POST['Executor'])){
                    $executor->attributes = $_POST['Executor'];
                    $executor->trustwill_id = $tw_id;
                    $executor->save();
                }
                $this->redirect(array('admin'));
            }
            $this->render('trustwill',array('model'=>$model,'case_id'=>$cd,'trusta'=>$trusta,'trustb'=>$trustb,'testator'=>$testator,'executor'=>$executor));
        }
        
        public function actionFamilylaw($cd = null){
            $this->layout ="logged";
            $model = new Familylaw;
            $child = new Childreninfo;
            $marital = new Maritalinfo;
            $spouse = new Spouseinfo;
            if(isset($_POST['Familylaw']) && !Yii::app()->request->isAjaxRequest){                
                $model->attributes = $_POST['Familylaw'];
                $model->save();
                $family_id = $model->primaryKey;
                if(isset($_POST['Childreninfo'])){
                    foreach($_POST['Childreninfo'] as $ci){
                        $child = new Childreninfo();
                        $child->attributes = $ci;
                        $child->familylaw_id = $family_id;
                        $child->save();
                    }
                }
                if(isset($_POST['Maritalinfo'])){
                    $marital->attributes = $_POST['Maritalinfo'];
                    $marital->familylaw_id = $family_id;
                    $marital->save();
                }
                if(isset($_POST['Spouseinfo'])){
                    $spouse->attributes = $_POST['Spouseinfo'];
                    $spouse->familylaw_id = $family_id;
                    $spouse->save();
                }
                $this->redirect(array('admin'));
            }
            $this->render('family',array('model'=>$model,'case_id'=>$cd,'spouse'=>$spouse,'child'=>$child,'marital'=>$marital));
        }
        
        public function actionPersonalinjury($cd = null){
            $this->layout ="logged";
            $model = new Personalinjury;
            $insurance = new Insuranceca;
            $defendent = new Defendentautoinfo;
            $property = new Propertydamage;
            $health = new Healthins;
            $medical = new Medicalsprovider;            
            if(isset($_POST['Personalinjury']) && !Yii::app()->request->isAjaxRequest){   
                //var_dump($_POST);
                //die();
                $model->attributes = $_POST['Personalinjury'];
                $model->save();
                $pi_id = $model->primaryKey;
                if(isset($_POST['Defendentautoinfo'])){
                    foreach($_POST['Defendentautoinfo'] as $ci){
                        $child = new Defendentautoinfo;
                        $child->attributes = $ci;
                        $child->personalinjury_id = $pi_id;
                        $child->save();
                    }
                }
                if(isset($_POST['Medicalsprovider'])){
                    foreach($_POST['Medicalsprovider'] as $ci){
                        $child = new Medicalsprovider;
                        $child->attributes = $ci;
                        $child->personalinjury_id = $pi_id;
                        $child->save();
                    }
                }
                if(isset($_POST['Insuranceca'])){
                    $insurance->attributes = $_POST['Insuranceca'];
                    $insurance->personalinjury_id = $pi_id;
                    $insurance->save();
                }
                if(isset($_POST['Propertydamage'])){
                    $property->attributes = $_POST['Propertydamage'];
                    $property->personalinjury_id = $pi_id;
                    $property->save();
                }
                if(isset($_POST['Healthins'])){
                    $health->attributes = $_POST['Healthins'];
                    $health->personalinjury_id = $pi_id;
                    $health->save();
                }
                $this->redirect(array('admin'));
            }
            $this->render('personal',array('model'=>$model,'case_id'=>$cd,'medical'=>$medical,'insurance'=>$insurance,'defendant'=>$defendent,'property'=>$property,'health'=>$health));
        }
        
        public function actionProbate($cd = null){
            $this->layout ="logged";
            $model = new Probateinfo;
            if(isset($_POST['Probateinfo']) && !Yii::app()->request->isAjaxRequest){
                $model->attributes = $_POST['Probateinfo'];
                $model->save();
                $this->redirect(array('admin'));
            }
            $this->render('probate',array('model'=>$model,'case_id'=>$cd));
        }
        
        public function actionCetsprovider($cd = null){
            $this->layout ="logged";
            $model = new Cetsprovider;
            if(isset($_POST['Cetsprovider']) && !Yii::app()->request->isAjaxRequest){
                $model->attributes = $_POST['Cetsprovider'];
                $model->save();
                $this->redirect(array('admin'));
            }
            $this->render('cetsprovider',array('model'=>$model,'case_id'=>$cd));
        }
		
		public function actionSendinv($slug){
			if(isset($_SESSION['client'])){
				$html2pdf = Yii::app()->ePdf->HTML2PDF();
				$this->layout = 'logged';
				$cinv = new Cinvoice;            
				$q = new CDbCriteria;
				$q->compare('slug',$slug);
				$cit = $cinv->find($q);	    
				$mPDF1 = Yii::app()->ePdf->mpdf();
				$mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
				$stylesheet = file_get_contents(dirname(dirname(dirname(__FILE__))). DIRECTORY_SEPARATOR .'css'.DIRECTORY_SEPARATOR.'invoice_style.css');
				$stylesheet1 = file_get_contents(dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR .'css'.DIRECTORY_SEPARATOR.'invoice_print.css');
				$mPDF1->WriteHTML($stylesheet, 1);
				$mPDF1->WriteHTML($stylesheet1, 1);
				$mPDF1->WriteHTML($this->renderPartial('_viewin', array('data'=>$cit), true)); 
				$mPDF1->Output(dirname(dirname(dirname(__FILE__))).'/invoice/'.$slug.'.pdf', EYiiPdf::OUTPUT_TO_FILE);
				$mail = new YiiMailer();
				//$mail->clearLayout();//if layout is already set in config
				$cl = User::model()->findByPk($_SESSION['client']);
				// var_dump($cl->email);
				// die();
				$mail->setFrom('no@plawza.com', 'Plawza');
				$mail->setTo($cl->email);
				$mail->setCc('dhimandee@gmail.com');
				$mail->setSubject('Invoice from Plawza');
				$mail->setBody('This is an Automated mail from Plawza.com providing Invoice as attachment.');
				$mail->setAttachment(dirname(dirname(dirname(__FILE__))).'/invoice/'.$slug.'.pdf');
				$mail->send();
				Cinvoice::model()->updateByPk($cit->id,array('is_draft'=>'0'));
				Yii::app()->user->setFlash('message', " Invoice Sent to Client.");
				// $this->redirect(Yii::app()->request->urlReferrer);
			}
			$this->redirect(Yii::app()->request->urlReferrer);
		}
        
        public function actionIexport($slug){
            $html2pdf = Yii::app()->ePdf->HTML2PDF();
            $this->layout = 'logged';
            $cinv = new Cinvoice;
            //$cits=new Cits;
            //$iits=new Iits;
            $q = new CDbCriteria;
            // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('slug',$slug);
            $cit = $cinv->find($q);
	    
            $mPDF1 = Yii::app()->ePdf->mpdf();
 
        # You can easily override default constructor's params
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
 
        # render (full page)
        //$mPDF1->WriteHTML($this->render('_viewin', array('data'=>$cit), true));
 
        # Load a stylesheet
        $stylesheet = file_get_contents(dirname(dirname(dirname(__FILE__))). DIRECTORY_SEPARATOR .'css'.DIRECTORY_SEPARATOR.'invoice_style.css');
        $stylesheet1 = file_get_contents(dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR .'css'.DIRECTORY_SEPARATOR.'invoice_print.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($stylesheet1, 1);
 
        # renderPartial (only 'view' of current controller)
        $mPDF1->WriteHTML($this->renderPartial('_viewin', array('data'=>$cit), true));
 
        # Renders image
        //$mPDF1->WriteHTML(CHtml::image(Yii::getPathOfAlias('webroot.css') . '/bg.gif' ));
 
        # Outputs ready PDF
        $mPDF1->Output();
        //$mPDF1->Output(dirname(dirname(__FILE__)).'/file.pdf', EYiiPdf::OUTPUT_TO_FILE);
        
        // $this->render('viewi',array(			
        //            'model'=>$cit,			
        //    ));
            
            //$html2pdf->WriteHTML($this->renderPartial('_viewin', array('data'=>$cit),true));
            //$html2pdf->Output();
            //$html2pdf->Output(dirname(dirname(__FILE__)).'/file.pdf', EYiiPdf::OUTPUT_TO_FILE);
                
	}

        public function actionWexports($slug) {
            
            $cinv = new Cinvoice;
            //$cits=new Cits;
            //$iits=new Iits;
            $q = new CDbCriteria;
            // $q->join = 'left join authassignment on authassignment.userid = t.id';
            $q->compare('slug',$slug);
            $cit = $cinv->find($q);
            $div = $this->renderPartial('_viewin1', array('data'=>$cit), true);
//            header("Pragma: no-cache");
//            header("Expires: 0");
//            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
              header("Content-type: application/vnd.ms-word");
              header("Content-Disposition: attachment;Filename=report_".date("d_m_Y_G_i").".doc");
//            header("Cache-Control: private", false);
//            header("Content-type: application/vnd.ms-word");
//            header("Content-Disposition: attachment; filename=\"test.doc");
//            header("Content-Transfer-Encoding: binary");
              ob_clean();
              flush();
              echo $div;
        
            Yii::app()->end();
        }
        
        public function actionWexport($slug) {
   //first unregister Yii base Autoload    
   spl_autoload_unregister(array('YiiBase','autoload'));
   Yii::import('application.vendors.*');
   Yii::setPathOfAlias('phpword',Yii::getPathOfAlias('application.vendors.phpword'));
 
   require('PHPWord/PHPWord.php');
   require_once 'phpword/PHPWord.php';
   require_once 'simplehtmldom/simple_html_dom.php';
   require_once 'htmltodocx_converter/h2d_htmlconverter.php';
   require_once 'example_files/styles.inc';
 
   $PHPWord = new PHPWord();
   spl_autoload_register(array('YiiBase','autoload')); 
 
   //$mCanvasType = Yii::app()->user->getState('mCanvasType'); 
   //Your Yii methods variables call here
   //or you can call your method ie.
   //$html = $this->html->data();//returned $html or your HTML/XHTML DOM.
   $cinv = new Cinvoice;
    //$cits=new Cits;
    //$iits=new Iits;
    $q = new CDbCriteria;
    // $q->join = 'left join authassignment on authassignment.userid = t.id';
    $q->compare('slug',$slug);
    $cit = $cinv->find($q);
    $html = $this->renderPartial('_viewin', array('data'=>$cit), true);

   spl_autoload_unregister(array('YiiBase','autoload'));
 
   $phpword_object = new PHPWord();
   $section = $phpword_object->createSection();
   $html_dom = new simple_html_dom();
   //$html_dom->load('html body' . $html . 'body html'); // here $html is the Html/XHTML DOM Which You Have to pass
   $html_dom->load($html);
   $html_dom_array = $html_dom->find('html',0)->children();   
   $initial_state = array(
 
      // Required parameters:
      'phpword_object' => &$phpword_object, // Must be passed by reference.
      'base_root' => 'http://test.local', // Required for link elements - change it to your domain.
      'base_path' => '/htmltodocx/', // Path from base_root to whatever url your links are relative to.
 
      // Optional parameters - showing the defaults if you don't set anything:
      'current_style' => array('size' => '11'), // The PHPWord style on the top element - may be inherited by descendent elements.
      'parents' => array(0 => 'body'), // Our parent is body.
      'list_depth' => 0, // This is the current depth of any current list.
      'context' => 'section', // Possible values - section, footer or header.
      'pseudo_list' => TRUE, // NOTE: Word lists not yet supported (TRUE is the only option at present).
      'pseudo_list_indicator_font_name' => 'Wingdings', // Bullet indicator font.
      'pseudo_list_indicator_font_size' => '7', // Bullet indicator size.
      'pseudo_list_indicator_character' => 'l ', // Gives a circle bullet point with wingdings.
      'table_allowed' => TRUE, // Note, if you are adding this html into a PHPWord table you should set this to FALSE: tables cannot be nested in PHPWord.
      'treat_div_as_paragraph' => TRUE, // If set to TRUE, each new div will trigger a new line in the Word document.
 
      // Optional - no default:    
      'style_sheet' => htmltodocx_styles_example(), // This is an array (the "style sheet") - returned by htmltodocx_styles_example() here (in styles.inc) - see this function for an example of how to construct this array.
   );  
   htmltodocx_insert_html($section, $html_dom_array, $initial_state);
   $html_dom->clear(); 
   unset($html_dom);
 
   $h2d_file_uri = tempnam('', 'htd');
   $objWriter = PHPWord_IOFactory::createWriter($phpword_object, 'Word2007');
   $objWriter->save($h2d_file_uri);
 
   // Download the file:
   header('Content-Description: File Transfer');
   header('Content-Type: application/octet-stream');
   header('Content-Disposition: attachment; filename=example.docx');
   header('Content-Transfer-Encoding: binary');
   header('Expires: 0');
   header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
   header('Pragma: public');
   header('Content-Length: ' . filesize($h2d_file_uri));
   ob_clean();
   flush();
   $status = readfile($h2d_file_uri);
   unlink($h2d_file_uri);
   exit;
}
        
	/**

	 * Creates a new model.

	 * If creation is successful, the browser will be redirected to the 'view' page.

	 */
	
	protected function non_empty(array $a) {
		$this->ad = 0;
		// array_map(function($b) {
						////return empty($b) ? 0 : 1;
						// if(empty($b)){
							// $this->ad++;
						// }
					// },$a
				// );
		foreach($a as $key=>$val){
			if(empty($val)){
				$this->ad++;
			}
		}
		return $this->ad;
	}
	 
	protected function subCreate($case_id=null){
		// var_dump($_POST);
		$aparty = new Adverseparty;
		$courtinfo = new Courtinfo;
		$afap = new Afap;
		$afapa = new AfapAttorney;
		$contract = new Casecontract;
		$calendar = new Calendar;
		$criminallaw=new Criminallaw;
		$flaw =new Familylaw;
		$pinj =new Personalinjury;
		$imigrationinfo=new Imigrationinfo;
		$spouseinfo = new Spouseinfo;
		$maritalinfo = new Maritalinfo;
		$childreninfo = new Childreninfo;
		$insuranceca = new Insuranceca;
		$propertyd = new Propertydamage;
		$healthi = new Healthins;
		$medp = new Medicalsprovider;		
		$probateinfo=new Probateinfo;
		$realestateinfo=new Realestateinfo;
		$bsba = new Bsbainfo();
		
		$apcount=0;
		if(isset($_POST['Adverseparty']))
			$apcount = $this->non_empty($_POST['Adverseparty']);		
		$cocount = $this->non_empty($_POST['Courtinfo']);
		$afcount = $this->non_empty($_POST['Afap']);
		$concount='';
		
		if((isset($_POST['Insuranceca']) || isset($_POST['Defendentautoinfo']) || isset($_POST['Propertydamage']) || isset($_POST['Healthins']) || isset($_POST['Medicalsprovider']) ) && $_POST['Cases']['case_type'] == "Personal Injury") {
			// var_dump($_POST);
			// var_dump($pinj->primaryKey);
		
			if(isset($_POST['Personalinjury']['id']) && !empty($_POST['Personalinjury']['id'])){
				$pinj = Personalinjury::model()->findByPk($_POST['Personalinjury']['id']);
			}
			$pinj->case_id = $case_id;
			$pinj->save();
			if(!is_null($pinj->primaryKey)){
				$pinj_pk = $pinj->primaryKey;
			}else{
				$pinj_pk = $_POST['cid'];
			}
			$count_insurance = $this->non_empty($_POST['Insuranceca']);
			if(isset($_POST['Insuranceca']['id']) && !empty($_POST['Insuranceca']['id'])){
				$insuranceca = Insuranceca::model()->findByPk($_POST['Insuranceca']['id']);
			}
			// var_dump(isset($_POST['Insuranceca']));
			// if(isset($_POST['Insuranceca']) && $count_insurance){				
			if(isset($_POST['Insuranceca'])){				
				$insuranceca->attributes = $_POST['Insuranceca'];
				$dfr = $insuranceca->getMetaData()->columns;				
				foreach($dfr as $k=>$v){
					if(isset($_POST['Insuranceca'][$k])){
						$insuranceca->$k = $_POST['Insuranceca'][$k];
					}
				}
				$insuranceca->personalinjury_id = $pinj_pk;
				// var_dump($insuranceca->validate());
				$insuranceca->save();
			}
			$count_property = $this->non_empty($_POST['Propertydamage']);
			if(isset($_POST['Propertydamage']['id']) && !empty($_POST['Propertydamage']['id'])){
				$propertyd = Propertydamage::model()->findByPk($_POST['Propertydamage']['id']);
			}
			if(isset($_POST['Propertydamage'])){				
				//var_dump( $_POST['Propertydamage']);
				//$propertyd->attributes = $_POST['Propertydamage'];
				$dfr = $propertyd->getMetaData()->columns;				
				foreach($dfr as $k=>$v){
					if(isset($_POST['Propertydamage'][$k])){
						$propertyd->$k = $_POST['Propertydamage'][$k];
					}
				}
				$propertyd->personalinjury_id = $pinj_pk;
				// var_dump($propertyd->validate());
				$propertyd->save();
				// var_dump($propertyd->getErrors());
			}
			$count_health = $this->non_empty($_POST['Healthins']);
			if(isset($_POST['Healthins']['id']) && !empty($_POST['Healthins']['id'])){
				$healthi = Healthins::model()->findByPk($_POST['Healthins']['id']);
			}
			if(isset($_POST['Healthins'])){				
				//$healthi->attributes = $_POST['Healthins'];
                                 $dfr = $healthi->getMetaData()->columns;				
				foreach($dfr as $k=>$v){
					if(isset($_POST['Healthins'][$k])){
						$healthi->$k = $_POST['Healthins'][$k];
					}
				}
				$healthi->personalinjury_id = $pinj_pk;
				// var_dump($healthi->validate());
				$healthi->save();
			}
			$count_med = $this->non_empty($_POST['Medicalsprovider']);
			if(isset($_POST['Medicalsprovider']) ){
				foreach($_POST['Medicalsprovider'] as $medd){
					$medp = new Medicalsprovider;
					$mpff = true;
					if(isset($medd['id']) && !empty($medd['id'])){
						$medp = Medicalsprovider::model()->findByPk($medd['id']);
						$mpff=false;
					}					
					$medp->attributes = $medd;
					$dfr = $medp->getMetaData()->columns;				
					foreach($dfr as $k=>$v){
						if(isset($medd[$k])){
							$medp->$k = $medd[$k];
						}
					}
					$medp->personalinjury_id = $pinj_pk;
					$count_med = $this->non_empty($medd);
					// if($count_med<=12){
						// var_dump($count_med);
					$medp->save();	
					$mpk = $medp->primaryKey;
					$data['ftype'] = 'Individual';
					$data['first_name'] = $medd['first_name'];
					$data['last_name'] = $medd['last_name'];
					// $data['company_name'] = $_REQUEST['Spouseinfo']['company_name'];
					$data['refer'] = 'medicalsprovider';
					$data['id'] = $mpk;
					if($mpff)
						$this->addConflict($data);
					// }			
					// die();
				}
			}
			$count_def = $this->non_empty($_POST['Defendentautoinfo']);
			if(isset($_POST['Defendentautoinfo'])){
				foreach($_POST['Defendentautoinfo'] as $defa){
					$def = new Defendentautoinfo;
					if(isset($defa['id']) && !empty($defa['id'])){
						$def = Defendentautoinfo::model()->findByPk($defa['id']);
					}
                                        
					//$def->attributes = $defa;
					$dfr = $def->getMetaData()->columns;				
					foreach($dfr as $k=>$v){
						if(isset($defa[$k])){
							$def->$k = $defa[$k];
						}
					}
                                //var_dump($defa);
					$def->personalinjury_id = $pinj_pk;
					$count_def = $this->non_empty($defa);
					// if($count_def<=20)
						$def->save();					
				}
			}
		}
		
		$count_familylaw='';
			
		if(isset($_POST['Familylaw']) || isset($_POST['Spouseinfo']) || isset($_POST['Maritalinfo']) || isset($_POST['Childreninfo'])){
			// $count_familylaw = $this->non_empty($_POST['Familylaw']);
			$count_spouse = $this->non_empty($_POST['Spouseinfo']);
			$count_martial = $this->non_empty($_POST['Maritalinfo']);
			$count_child = $this->non_empty($_POST['Childreninfo']);
			if(isset($_POST['Familylaw']['id']) && !empty($_POST['Familylaw']['id'])){
				$flaw = Familylaw::model()->findByPk($_POST['Familylaw']['id']);
			}
			// $flaw=  UserController::getAttribute($flaw, 'Familylaw');
			$dfr = $flaw->getMetaData()->columns;				
			foreach($dfr as $k=>$v){					
				if(isset($_POST['Familylaw'][$k])){
					$flaw->$k = $_POST['Familylaw'][$k];
				}
			}
			$flaw->case_id = $case_id;
			$flaw->save();
			$flaw_pk = $flaw->primaryKey;
			$stff = true;
			if(isset($_POST['Spouseinfo']['id']) && !empty($_POST['Spouseinfo']['id'])){
				$spouseinfo = Spouseinfo::model()->findByPk($_POST['Spouseinfo']['id']);
				$stff = false;
			}
			if(isset($_POST['Spouseinfo'])){
				// echo 'vfhfdg';
				// var_dump($_POST);
				$spouseinfo->attributes = $_POST['Spouseinfo'];
				$dfr = $spouseinfo->getMetaData()->columns;				
				foreach($dfr as $k=>$v){					
					if(isset($_POST['Spouseinfo'][$k])){
						$spouseinfo->$k = $_POST['Spouseinfo'][$k];
					}
				}
                                
				$spouseinfo->familylaw_id = $flaw_pk;
				$spouseinfo->save();
				$spk = $spouseinfo->primaryKey;
				$data['ftype'] = 'Individual';
				$data['first_name'] = $_REQUEST['Spouseinfo']['first_name'];
				$data['last_name'] = $_REQUEST['Spouseinfo']['last_name'];
				// $data['company_name'] = $_REQUEST['Spouseinfo']['company_name'];
				$data['refer'] = 'spouseinfo';
				$data['id'] = $spk;
				if($stff)
					$this->addConflict($data);
			}
			if(isset($_POST['Maritalinfo']['id']) && !empty($_POST['Maritalinfo']['id'])){
				$maritalinfo = Maritalinfo::model()->findByPk($_POST['Maritalinfo']['id']);
			}
			if(isset($_POST['Maritalinfo']) ){
				// var_dump($_POST);
				$maritalinfo->attributes = $_POST['Maritalinfo'];
				$dfr = $maritalinfo->getMetaData()->columns;				
				foreach($dfr as $k=>$v){					
					if(isset($_POST['Maritalinfo'][$k])){
						$maritalinfo->$k = $_POST['Maritalinfo'][$k];
					}
				}
				$maritalinfo->familylaw_id = $flaw_pk;
				$maritalinfo->save();
			}
			foreach($_POST['Childreninfo'] as $chi){
				$childreninfo = new Childreninfo;
				if(isset($chi['id']) && !empty($chi['id'])){
					$childreninfo = Childreninfo::model()->findByPk($chi['id']);
				}				
				if(isset($chi)){
					$childreninfo->attributes = $chi;
					$childreninfo->dob = date('Y-m-d',strtotime($chi['dob']));
					$dfr = $childreninfo->getMetaData()->columns;				
					foreach($dfr as $k=>$v){					
						if(isset($chi[$k])){
							$childreninfo->$k = $chi[$k];
							// echo $k.' = = '.$chi[$k];
						}
						// $childreninfo=  UserController::getAttribute($childreninfo, 'childreninfo');
					}
                                       
					$childreninfo->familylaw_id = $flaw_pk;
					$childreninfo->save();
				}
			}
			// die();
		}
		
		if(isset($_POST['Casecontract']))
			$concount = $this->non_empty($_POST['Casecontract']);
		//$concount = $this->non_empty($_POST['Casecontract']);
		$count_countcriminallaw='';
		if(isset($_POST['Criminallaw'])){
			$count_countcriminallaw = $this->non_empty($_POST['Criminallaw']);
			if(isset($_POST['Criminallaw'])) {
				if(isset($_POST['Criminallaw']['id']) && !empty($_POST['Criminallaw']['id'])){
					$criminallaw = Criminallaw::model()->findByPk($_POST['Criminallaw']['id']);
				}
				$criminallaw->attributes = $_POST['Criminallaw'];			
				$dfr = $criminallaw->getMetaData()->columns;				
				foreach($dfr as $k=>$v){					
					if(isset($_POST['Criminallaw'][$k])){
						$criminallaw->$k = $_POST['Criminallaw'][$k];
					}
				}
				$criminallaw->case_id = $case_id;				 
				$criminallaw->save();
			}
		}
		$count_imigrationinfo='';
		if(isset($_POST['Imigrationinfo']))
			$count_imigrationinfo = $this->non_empty($_POST['Imigrationinfo']);
			
		$count_probateinfo='';
		if(isset($_POST['Probateinfo']))
			$count_probateinfo = $this->non_empty($_POST['Probateinfo']);
		$count_realestateinfo='';
		if(isset($_POST['Realestateinfo']))
			$count_realestateinfo = $this->non_empty($_POST['Realestateinfo']);
			// var_dump($_POST['Realestateinfo']);
		//die();
		if(  isset($_POST['Realestateinfo'])) {
			$ftff=true;
			if(isset($_POST['Realestateinfo']['id']) && !empty($_POST['Realestateinfo']['id'])){
				$realestateinfo = Realestateinfo::model()->findByPk($_POST['Realestateinfo']['id']);
				if(isset($_POST['Bsbainfo']['id']) && !empty($_POST['Bsbainfo']['id'])){
					$bsba = Bsbainfo::model()->findByPk($_POST['Bsbainfo']['id']);
					$ftff=false;
				}
				
				// $errores = $bsba->getErrors();
				// var_dump($errores);
			}
			$realestateinfo->attributes = $_POST['Realestateinfo'];
			$realestateinfo->closing_date=date('Y-m-d',strtotime($_POST['Realestateinfo']['closing_date']));
			$realestateinfo->acceptance_date=date('Y-m-d',strtotime($_POST['Realestateinfo']['acceptance_date']));
			$realestateinfo->property_address=$_POST['Realestateinfo']['property_address'];
			$realestateinfo->closing_time=$_POST['Realestateinfo']['closing_time'];
                       
			
                        //$realestateinfo=  UserController::getAttribute($realestateinfo, 'Realestateinfo');
			$realestateinfo->case_id = $case_id;
			$realestateinfo->sales_price=$_POST['Realestateinfo']['sales_price'];
			$realestateinfo->purchase_price=$_POST['Realestateinfo']['purchase_price'];
			$realestateinfo->earnest_money=$_POST['Realestateinfo']['earnest_money'];
			$realestateinfo->cost_paid_seller=$_POST['Realestateinfo']['cost_paid_seller'];
			$realestateinfo->cost_paid_buyer=$_POST['Realestateinfo']['cost_paid_buyer'];
			$dfr = $realestateinfo->getMetaData()->columns;				
			foreach($dfr as $k=>$v){					
				if(isset($_POST['Realestateinfo'][$k])){
					$realestateinfo->$k = $_POST['Realestateinfo'][$k];
				}
			}
			$realestateinfo->save();			
			$real_pk = $realestateinfo->primaryKey;
			$dfr = $bsba->getMetaData()->columns;				
			foreach($dfr as $k=>$v){					
				if(isset($_POST['Bsbainfo'][$k])){
					$bsba->$k = $_POST['Bsbainfo'][$k];					
					// var_dump($k);
					// var_dump($_POST['Bsbainfo'][$k]);
				}
			}
			// $bsba->phone = $_POST['Bsbainfo']['phone'];
			// $bsba->mobile = $_POST['Bsbainfo']['mobile'];
			// $bsba->email = $_POST['Bsbainfo']['email'];
			$bsba->realestateinfo_id = $real_pk;
			$bsba->save();
			
			$spk = $bsba->primaryKey;
			$data['ftype'] = '';
			$data['first_name'] = $_REQUEST['Bsbainfo']['first_name'];
			$data['last_name'] = $_REQUEST['Bsbainfo']['last_name'];
			$data['company_name'] = $_REQUEST['Spouseinfo']['company_name'];
			$data['refer'] = 'bsbainfo';
			$data['id'] = $spk;
			if($ftff)
				$this->addConflict($data);
			
		}
		// var_dump($_POST);
		// die();
		if($count_probateinfo<10 &&  isset($_POST['Probateinfo']) && $_POST['Cases']['case_type'] == "Probate") {
			if(isset($_POST['Probateinfo']['id']) && !empty($_POST['Probateinfo']['id'])){
				$probateinfo = Probateinfo::model()->findByPk($_POST['Probateinfo']['id']);
			}
			$probateinfo->attributes = $_POST['Probateinfo'];
                        $dfr = $probateinfo->getMetaData()->columns;				
			foreach($dfr as $k=>$v){
				if(isset($_POST['Probateinfo'][$k])){
					$probateinfo->$k = $_POST['Probateinfo'][$k];
				}
			}
			$probateinfo->death_date=date('Y-m-d',strtotime($_POST['Probateinfo']['death_date']));
			$probateinfo->date_of_will=date('Y-m-d',strtotime($_POST['Probateinfo']['date_of_will']));
			
			$probateinfo->case_id = $case_id;
			  
			$probateinfo->save();
		}
		if($count_imigrationinfo<18 &&  isset($_POST['Imigrationinfo']) && $_POST['Cases']['case_type'] == "Immigration") {
			if(isset($_POST['Imigrationinfo']['id']) && !empty($_POST['Imigrationinfo']['id'])){
				$imigrationinfo = Imigrationinfo::model()->findByPk($_POST['Imigrationinfo']['id']);
			}			
			$dfr = $imigrationinfo->getMetaData()->columns;				
			foreach($dfr as $k=>$v){
				if(isset($_POST['Imigrationinfo'][$k])){
					$imigrationinfo->$k = $_POST['Imigrationinfo'][$k];
				}
			}
			
			$imigrationinfo->case_id = $case_id;
			  
			$imigrationinfo->save();
		}		
		if($apcount<15) {			
			$aparty->attributes = $_POST['Adverseparty'];
			$aparty->case_id = $case_id;
			//$aparty->save();
		}		
		if($cocount<12) {
			if(isset($_POST['Courtinfo']['id']) && !empty($_POST['Courtinfo']['id'])){
				$courtinfo = Courtinfo::model()->findByPk($_POST['Courtinfo']['id']);
			}
			//$courtinfo->attributes = $_POST['Courtinfo'];
                        $courtinfo=  UserController::getAttribute($courtinfo, 'Courtinfo');
			$courtinfo->case_id = $case_id;
			$courtinfo->save();
		}
		// if($afcount<11) {
		if(isset($_POST['Afap'])) {
			// var_dump($_POST);
			if( isset($_POST['Afap']['adverseparty_id']) && !empty($_POST['Afap']['adverseparty_id']) ){
				if(isset($_POST['Afap']['id']) && !empty($_POST['Afap']['id'])){
					$afap = Afap::model()->findByPk($_POST['Afap']['id']);
				}
				$afap->attributes = $_POST['Afap'];
				$afap->city = $_POST['Afap']['city'];
				$afap->state = $_POST['Afap']['state'];
				$afap->zip = $_POST['Afap']['zip'];
				$afap->website = $_POST['Afap']['website'];
				$afap->phone1 = $_POST['Afap']['phone1'];
				$afap->phone2 = $_POST['Afap']['phone2'];
				$dfr = $afap->getMetaData()->columns;				
				foreach($dfr as $k=>$v){
					if(isset($_POST['Afap'][$k])){
						$afap->$k = $_POST['Afap'][$k];
					}
				}
				$afap->case_id = $case_id;
				// $afap= UserController::getAttribute($afap, 'Afap');
				$afap->save();
				// var_dump($afap->getErrors());
				$afap_pk = $afap->primaryKey;
                                
                        
				foreach($_POST['AfapAttorney'] as $afa){
                                    $afapa = new AfapAttorney;//AfapAttorney;
                                    //var_dump($afa);
					if(isset($afa['id']) && !empty($afa['id'])){
						$afapa = AfapAttorney::model()->findByPk($afa['id']);
					}
                                        
					$afapa->attributes = $afa;
					$dfr = $afapa->getMetaData()->columns;				
					foreach($dfr as $k=>$v){
						if(isset($afa[$k])){
							$afapa->$k = $afa[$k];
						}
					}
					$afapa->afap_id = $afap_pk;
                                        
					$afapa->save();
				}
			}
		}
		if($concount<7 && isset($_POST['Casecontract'])) {
			if(isset($_POST['Casecontract']['id']) && !empty($_POST['Casecontract']['id'])){
				$contract = Casecontract::model()->findByPk($_POST['Casecontract']['id']);
			}
			$contract->attributes = $_POST['Casecontract'];
			$contract->contact_date = date('Y-m-d',strtotime($_POST['Casecontract']['contact_date']));
			$contract->breach_date = date('Y-m-d',strtotime($_POST['Casecontract']['breach_date']));
			$contract->case_id = $case_id;
			$contract->facts = $_POST['Casecontract']['facts'];
			$contract->contract_terms = $_POST['Casecontract']['contract_terms'];
			$contract->save();
		}
		// die();
	}
	
	public function actionNupdate($id = null){
		// $this->layout="admin";
		// var_dump($_POST);
		// die();
		$this->layout="newd1";
		$this->dbswitch(Yii::app()->user->firm_id);		
		// $model = $this->loadModel($id);		
		$model = Cases::model()->findByPk($id);
		$user = new User;		
		$ocei = new Ocei;
		$ocedi = new Ocedi;
		$casead = new Casead;
		$courtinfo = new Courtinfo;
		$aparty = new Adverseparty;
		$afap = new Afap;	
		$apattorney = new AfapAttorney;
		$contract = new Casecontract;
		$probate = new Probateinfo;
		$criminal=new Criminallaw;
		$migrate = new Imigrationinfo;
		$courtinfo = new Courtinfo();
		$estate = new Realestateinfo;
		$personal = new Personalinjury();
		$family = new Familylaw();
		$spouse = new Spouseinfo();
		$marital = new Maritalinfo();
		$child = new Childreninfo();
		$childd = '';
		$bsba = new Bsbainfo();
		$insurance = new Insuranceca;
		$defendent = new Defendentautoinfo;
		$property = new Propertydamage;
		$health = new Healthins;
		$medical = new Medicalsprovider;
		$medicals=$defendents='';
		$aat = new CaseUser;  
		$apattorneys='';
		$selections='';
		$sselections='';
		$sq = new CDbCriteria;
		$sq->join = " left join authassignment au on au.userid = t.id";
		$sq->compare('au.itemname','Admin');
		// $sq->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
		$susr = $user->findAll($sq);
		$selections= $susr;		
		
		if(isset($model->usr)){
			if(count($model->usr)>=1){
				$selections = $model->usr;
				$usere = new User;
				$sq = new CDbCriteria;
				$sq->join = " left join case_user au on au.user_id = t.id";
				$sq->compare('au.case_id',$model->id);					
				$sq->compare('au.utype','staff');					
				$susr = $usere->findAll($sq);
				$sselections= $susr;
				// var_dump($sselections);
			}
		}
		
		switch($model->case_type){
			case 'Contracts':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$cdd = $contract->find($cq);
				if(isset($cdd->id))
					$contract = Casecontract::model()->findByPk($cdd->id);				
				break;
			case 'Criminal Law':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$cri = $criminal->find($cq);
				if(isset($cri->id))
					$criminal = Criminallaw::model()->findByPk($cri->id);
				break;
			case 'Family Law':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$fam = $family->find($cq);
				if(isset($fam->id)){
					$family = Familylaw::model()->findByPk($fam->id);
					$cq = new CDbCriteria();
					$cq->compare('t.familylaw_id',$fam->id);
					$sp = $spouse->find($cq);
					// var_dump($fam->id);
					if(isset($sp->id))
						$spouse = Spouseinfo::model()->findByPk($sp->id);
					$ps = $marital->find($cq);
					// var_dump($ps->id);
					if(isset($ps->id))
						$marital = Maritalinfo::model()->findByPk($ps->id);
					$vd = new CDbCriteria;
					$vd->compare('t.familylaw_id',$fam->id);
					$childd = $child->findAll($vd);
				}
				break;
			case 'Immigration':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$mig = $migrate->find($cq);
				if(isset($mig->id))
					$migrate = Imigrationinfo::model()->findByPk($mig->id);
				break;
			case 'Probate':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$pro = $probate->find($cq);
				if(isset($pro->id))
					$probate = Probateinfo::model()->findByPk($pro->id);
				break;
			case 'Personal Injury':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$per = $personal->find($cq);
				if(isset($per->id)){
					$personal = Personalinjury::model()->findByPk($per->id);
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$per->id);
					$ine = $insurance->find($cq);
					if(isset($ine->id))
						$insurance = Insuranceca::model()->findByPk($ine->id);
				
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$personal->id);
					$hea = $health->find($cq);
					if(isset($hea->id))
						$health = Healthins::model()->findByPk($hea->id);
						
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$personal->id);
					// var_dump($personal->id);
					$heaa = $property->find($cq);
					if(isset($heaa->id))
						$property = Propertydamage::model()->findByPk($heaa->id);
				}
				$cq = new CDbCriteria();
				if(isset($personal->id)){
					$cq->compare('t.personalinjury_id',$personal->id);
					$medicals = $medical->findAll($cq);
				}
				$cq = new CDbCriteria();
				$cq->compare('t.personalinjury_id',$personal->id);
				$defendents = $defendent->findAll($cq);
				// if(isset($med)){
					// $meds = $medical->findAll($);
					// $medical = Medicalsprovider::model()->findByPk($med->id);
				// }
				break;
			case 'Real Estate':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$rea = $estate->find($cq);
				if(isset($rea->id)){
					$estate = Realestateinfo::model()->findByPk($rea->id);
					$fd = new CDbCriteria;
					$fd->compare('realestateinfo_id',$rea->id);
					$bs = $bsba->find($fd);
					if(isset($bs->id))
						$bsba = Bsbainfo::model()->findByPk($bs->id);
				}
				break;
			default:				
				break;
		}
		
		$cd = new CDbCriteria();
		$cd->compare('t.case_id',$id);
		$cI = $courtinfo->find($cd);
		if(isset($cI->id)){
			$courtinfo = Courtinfo::model()->findByPk($cI->id);
		}
		$cIi = $afap->find($cd);
		if(isset($cIi->id)){
			$afap = Afap::model()->findByPk($cIi->id);
			$cad = new CDbCriteria;
			$cad->compare('t.afap_id',$cIi->id);
			$cIa = $apattorney->findAll($cad);
			if(count($cIa)>=3){
				// $apattorney = Apattorney::model()->findByPk($cIa->id);
				$apattorneys = $cIa;
			}
		}
		
		$conI = $contract->find($cd);
		if(isset($conI->id)){
			$contract = Casecontract::model()->findByPk($conI->id);
		}
		$q = new CDbCriteria();
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';		
		$q->addCondition("(authassignment.itemname like 'Attorney' or authassignment.itemname like 'Admin')", 'AND');
		$rft = Yii::app()->user->firm_id;
		$q->compare('t.firm_id',$rft);
		$attorney = $user->findAll($q);                
		$q = new CDbCriteria();
		$q->compare('status','1');
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';
		$q->compare('authassignment.itemname','Staff');
		$q->compare('t.firm_id',Yii::app()->user->firm_id);
		$users = $paralegal = $user->findAll($q);
		if(isset($_POST['ajax']) && $_POST['ajax']==='casess-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}		
		$this->writeLog = false;
		$cid=$id;$apdataprovider='';
		$apdataprovider = new CActiveDataProvider('Adverseparty',array(
                        'criteria'=>array(
                            //'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            'condition'=>'t.case_id=\''.$id.'\'',
                            'order'=>'t.created DESC',
                            // 'join'=>'LEFT JOIN authassignment ON authassignment.userid = t.id',
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('afaps' ),        
                            // 'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>6,
                        ), 
                    ));	
		$apar = new Adverseparty();
		$cd = new CDbCriteria();
		$cd->compare('t.case_id',$id);				
		$aparties = $apar->findAll($cd);
		// $sql = "SELECT *, concat(last_name,', ',first_name) as fullname from adverseparty where id not in (SELECT adverseparty.id as counter FROM `adverseparty` inner join afap on afap.adverseparty_id=adverseparty.id WHERE 1) and adverseparty.case_id='".$id."'";
		// $sql = "SELECT *, concat(last_name,', ',first_name) as fullname from adverseparty where adverseparty.case_id='".$id."'";
		// $connection = Yii::app()->dynamicDb; 
		// $command = $connection->createCommand($sql);
		// $rowCount = $command->execute(); // execute the non-query SQL
		// $aparties = $command->query(); // execute a query SQL
		
		if(isset($_POST['Cases']) && !Yii::app()->request->isAjaxRequest){
			// var_dump($_POST);
			$clie = new Client;
			$cd = new CDbCriteria();
			$cdd = new CDbCriteria();
			if(isset($_SESSION['client'])){
				$cdd->compare('id',$_SESSION['client']);
			}else{
				$cdd->compare('id',$_POST['Cases']['user_id']);
			}
			// $cd->compare('user_id',$_SESSION['client']);
			// $clientss = $clie->find($cd);
			$clientsss = $clie->find($cdd);                         
			$model->attributes=$_POST['Cases'];
                         $model->user_id = $_POST['Cases']['user_id'];
			// $model->user_id = $_SESSION['client'];
			$model->assigned_attorney = $_POST['Cases']['assigned_attorney'];
			$model->assigned_staff = $_POST['Cases']['assigned_staff'];
			$model->nature_of_representation = $_POST['Cases']['nature_of_representation'];
			$model->statute_of_limitation = date('Y-m-d',strtotime($_POST['Cases']['statute_of_limitation']));
			$model->case_type = $_POST['Cases']['case_type'];
			$model->created_by = Yii::app()->user->id;
			$model->firm_id = $rft;
			$model->retainer_deposit = $_POST['Cases']['retainer_deposit'];
			$model->statue_applicable=$_POST['Cases']['statue_applicable'];
			//var_dump($model->save());
			// if(!isset($_POST['cid']) && !empty($_POST['cid']) && strlen($_POST['cid'])>=1){
			// if(!isset($_POST['cid']) && !empty($_POST['cid']) && strlen($_POST['cid'])>=1){
				$model->save();		
				//var_dump($model->getErrors());
				//die();
				$this->subCreate($_POST['cid']);				
				// die('assas');
				$model = $this->loadModel($_POST['cid']);
				// $cid=$_POST['cid'];
				// var_dump($_POST);
				$ur = new CaseUser;
                                 
				$cd = new CDbCriteria();
				$cd->compare('case_id',$_POST['cid']);
				// $cd->compare('utype','staff');
				$ur->deleteAll($cd);
                                
                        
                                //var_dump($_POST['Cases']['assigned_staff']);
                                
                                if(count($_POST['Cases']['assigned_staff'])>0)
                                {
				foreach($_POST['Cases']['assigned_staff'] as $u=>$c){
					$ur = new CaseUser;
					// $cd = new CDbCriteria();
					// $cd->compare('t.case_id',$_POST['cid']);
					// $cd->compare('t.utype','staff');
					// $ur->deleteAll($cd);
					$ur->case_id = $_POST['cid'];
					$ur->user_id = $c;
					$ur->utype = "staff";
					$ur->save();
					// die($c);
				}
                                }
								
					if(count($_POST['CaseUser']['user_id'])>0)
					{
						foreach($_POST['CaseUser']['user_id'] as $u=>$c){
							$ur = new CaseUser;							
							$ur->case_id = $_POST['cid'];
							$ur->user_id = $c;							
							$ur->save();							
						}
					}
			// }
                        //die();
			$this->redirect(array('case/admin'));
		}
		$isu=true;
		if(isset($_GET['ret'])){
			$isu=false;
		}
		$this->render('createe',array(
			'model'=>$model,			
			'cid'=>$cid,
			'contract'=>$contract,
			'probate'=>$probate,
			'criminal'=>$criminal,
			'apattorney'=>$apattorney,
			'apattorneys'=>$apattorneys,
			'apdataprovider'=>$apdataprovider,			
			'users'=>$users,
			'migrate'=>$migrate,			
			// 'ocapf'=>$ocapf,
			'estate'=>$estate,
			'personal'=>$personal,
                        'family'=>$family,
			'spouse'=>$spouse,
			'marital'=>$marital,
			'child'=>$child,
			'childd'=>$childd,
			'bsba'=>$bsba,
			'insurance'=>$insurance,
			'defendent'=>$defendent,
			'property'=>$property,
			'health'=>$health,
			'medical'=>$medical,
			'medicals'=>$medicals,
			'defendents'=>$defendents,
			'selections'=>$selections,
			'sselections'=>$sselections,
			'aat'=>$aat,
			'ocei'=>$ocei,
			'is_update'=>$isu,
			'aparty'=>$aparty,
			'afap'=>$afap,			
			'ocedi'=>$ocedi,
			// 'ocapfc'=>$ocapfc,
			'attorney'=>$attorney,
			'paralegal'=>$paralegal,
			'casead'=>$casead,
			'courtinfo'=>$courtinfo,
			'aparties'=>$aparties,
		));
	}
	
	public function addConflict($data){
		$conflict = new Conflict();
		$conflict->ftype = $data['ftype'];
		if($data['ftype']=='Corporate'){
			$conflict->company_name = $data['company_name'];
		}elseif($data['ftype']=='Individual'){
			$conflict->first_name = $data['first_name'];
			$conflict->last_name = $data['last_name'];
		}else{
			$conflict->company_name = $data['company_name'];
			$conflict->first_name = $data['first_name'];
			$conflict->last_name = $data['last_name'];
		}
		$conflict->refer = $data['refer'];
		$conflict[$data['refer'].'_id'] = $data['id'];
		return $conflict->save();
	}
	
	public function actionApartydel($id = null){
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->layout="admin";
		$model = Adverseparty::model()->findByPk($id);
		$case_id = $model->case_id;
		if($model===null){
			throw new CHttpException(404,'The requested page does not exist.');
		}
		$model->delete();
		$this->redirect(array('case/nupdate/'.$case_id));
	}
	
	public function actionGetcasegr(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$user_id = $_GET['c'];
		// $cd = new CDbCriteria;
		// $cd->join = "left join client c on c.id=t.user_id";
		// $cd->compare('c.user_id',$user_id);
		// $case = new Cases;
		// $cases = $case->findAll($cd);
		// $str="";$rt=1;
		// foreach($cases as $cas){
			// $str.='<tr>
						// <td class="hidden-xs">'.$rt.'</td>
						// <td>'.$cas->casenaam.'</td>						
						// <td><input type="radio" class="selcase" data-validate="validateCase" value="'.$cas->id.'" name="selcase" /></td>
					// </tr>';
			// $rt++;
		// }
		// if($rt==1){
			// $str.='<tr><td colspan="3"><a href="'.Yii::app()->createUrl('case/create/C/'.urlencode(base64_encode($_GET['c']))).'" class="btn btn-primary">No Case Available, Click Here to Add One</a></td></tr>';			
		// }
		// echo $str;
		// die('asdasd');
		$this->layout="ajax";
		if(Yii::app()->user->iisa){
			$dataProvider = new CActiveDataProvider('Cases',array(
                'criteria'=>array(
                    'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and cl.user_id = \''.$_GET['c'].'\'',
                    'order'=>'t.created DESC',
                    'join'=>'LEFT JOIN {{client}} cl ON cl.id = t.user_id',
                    //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                    // 'with'=>array('client' ),        
                    //'with'=>array('authassignment')
                ),
                'pagination'=>array(
                    'pageSize'=>5,
                ), 
            ));
		}else{
			$dataProvider = new CActiveDataProvider('Cases',array(
                'criteria'=>array(
                    'condition'=>'t.firm_id =\''.Yii::app()->user->firm_id.'\' and cl.user_id = \''.$_GET['c'].'\' and u.id = \''.Yii::app()->user->id.'\'',
                    'order'=>'t.created DESC',
                    'join'=>'LEFT JOIN {{client}} cl ON cl.id = t.user_id LEFT JOIN {{case_user}} cu on cu.case_id=t.id LEFT JOIN {{users}} u on u.id = cu.user_id ',
                    //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                    // 'with'=>array('client' ),        
                    //'with'=>array('authassignment')
                ),
                'pagination'=>array(
                    'pageSize'=>5,
                ), 
            ));
		}
		// $aj = '';
		// if(isset($_REQUEST['ajax'])){
			// $aj=$_REQUEST['ajax'];
		// }
		$this->render('csgrid',array('dataprovider'=>$dataProvider,'request'=>$_REQUEST));
		Yii::app()->end();
	}
	
	public function actionGetcases(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$user_id = $_GET['c'];
		$cd = new CDbCriteria;
		$cd->join = "left join client c on c.id=t.user_id";
		$cd->compare('c.user_id',$user_id);
		$case = new Cases;
		$cases = $case->findAll($cd);
		$str="";$rt=1;
		foreach($cases as $cas){
			$str.='<tr>
						<td class="hidden-xs">'.$rt.'</td>
						<td>'.$cas->casenaam.'</td>						
						<td><input type="radio" class="selcase" data-validate="validateCase" value="'.$cas->id.'" name="selcase" /></td>
					</tr>';
			$rt++;
		}
		if($rt==1){
			$str.='<tr><td colspan="3"><a href="'.Yii::app()->createUrl('case/create/C/'.urlencode(base64_encode($_GET['c']))).'" class="btn btn-primary">No Case Available, Click Here to Add One</a></td></tr>';
			// $_SESSION['client'] = $_GET['c'];
		}
		echo $str;
		Yii::app()->end();
	}
	
	public function actionApartyup($id = null){
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->layout="newd1";
		$model = Adverseparty::model()->findByPk($id);
		if($model===null){
			throw new CHttpException(404,'The requested page does not exist.');
		}
		if(isset($_POST['Adverseparty']) && !Yii::app()->request->isAjaxRequest){
			$model->attributes = $_POST['Adverseparty'];
			if($model->save()){
				if(isset($_GET['ret'])){
					$this->redirect(array('case/nupdate/'.$_POST['Adverseparty']['case_id'].'?ret='.$_GET['ret']));
				}else{
					$this->redirect(array('case/nupdate/'.$_POST['Adverseparty']['case_id']));
				}
			}
		}
		$this->render('apartyup',array(
			'model'=>$model,
			
		));
	}

	public function actionAddap(){
		// var_dump($_REQUEST);
		$this->dbswitch(Yii::app()->user->firm_id);
		$aparty = new Adverseparty;
		$aparty->attributes = $_REQUEST['Adverseparty'];
		$aparty->save();		
		$i = $aparty->primaryKey;
		$data['ftype'] = $_REQUEST['Adverseparty']['ftype'];
		$data['first_name'] = $_REQUEST['Adverseparty']['first_name'];
		$data['last_name'] = $_REQUEST['Adverseparty']['last_name'];
		$data['company_name'] = $_REQUEST['Adverseparty']['company_name'];
		$data['refer'] = 'adverseparty';
		$data['id'] = $i;
		$this->addConflict($data);
		echo $i;
	}
	
	public function actionRementry(){
		$data = $_REQUEST['data'];
		$dat = json_decode($data,true);
		// var_dump($dat);
		// die();
		if($_REQUEST['n']=="Expense"){
			if (($key = array_search($_REQUEST['d'], $dat['Exp'])) !== false) unset($dat['Exp'][$key]);
		}else{
			if (($key = array_search($_REQUEST['d'], $dat['Invo'])) !== false) unset($dat['Invo'][$key]);
		}
		$dat = json_encode($dat);
		echo $dat;
	}
	
	public function actionDynamicparty()
	{
		// var_dump($_REQUEST['c']);
		$this->dbswitch(Yii::app()->user->firm_id);
		$data = Adverseparty::model()->findAll('case_id=:case_id', array(':case_id'=>(int) $_REQUEST['c'])); 
		$data=CHtml::listData($data,'id','fullName');
		echo CHtml::tag('option', array('value'=>''),CHtml::encode('Please Select'),true);
		foreach($data as $value=>$name)
		{
			echo CHtml::tag('option', array('value'=>$value),CHtml::encode($name),true);
		}
	}
	
	public function actionCreate($C=null){
		$this->dbswitch(Yii::app()->user->firm_id);
		$model=new Cases;
		$this->layout="newd1";
		$user = new User;
		if(!isset($_SESSION['client'])){
			Yii::app()->user->setFlash('error',' No Client Selected, Please select a Client to Add Case.');
			$this->redirect(Yii::app()->request->getUrlReferrer());
		}
		//$court = new Court;
		$address = new Address;
		$counsel = new Counsel;
		$ocapf = new Ocapf;
		$ocapfc = new Ocapfc;
		$ocei = new Ocei;
		$ocedi = new Ocedi;
		$casead = new Casead;
		$courtinfo = new Courtinfo;
		$aparty = new Adverseparty;
		$afap = new Afap;
		$apattorney = new AfapAttorney;
		$mprovider = new Mprovider;
		$sprovider = new Sprovider;
		$adjustor = new Adjustor;
		$caseinfo = new Caseinfo;
		$contract = new Casecontract;
		$calendar = new Calendar;
		$probate = new Probateinfo;
		$criminal=new Criminallaw;
		$migrate = new Imigrationinfo;
		$estate = new Realestateinfo;
		$personal = new Personalinjury();
		$family = new Familylaw();
		$spouse = new Spouseinfo();
		$marital = new Maritalinfo();
		$child = new Childreninfo();
		$bsba = new Bsbainfo();
		$insurance = new Insuranceca;
		$defendent = new Defendentautoinfo;
		$property = new Propertydamage;
		$health = new Healthins;
		$work = new Workercomp;
		$emp = new Empinfo;
		$emp = new Empinfo;
		$medical = new Medicalsprovider;  
		$aat = new CaseUser;  
		$selections='';		
		$sselections='';		
		$sq = new CDbCriteria;
		$sq->join = " left join authassignment au on au.userid = t.id";
		$sq->compare('au.itemname','Admin');
		// $sq->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
		$susr = $user->findAll($sq);
		$selections= $susr;
		
		//$courts = $court->findAll();
		
		$usr = new CaseUser;

		$q = new CDbCriteria();

		//$q->compare('status','1');
                
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';
		//$q->compare('authassignment.itemname','Attorney');
		$q->addCondition("(authassignment.itemname like 'Attorney' or authassignment.itemname like 'Admin')", 'AND');
		$rft = Yii::app()->user->firm_id;
		// var_dump($rft);
		$q->compare('t.firm_id',$rft);
		$attorney = $user->findAll($q);                
		$q = new CDbCriteria();
		$q->compare('status','1');
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';
		$q->compare('authassignment.itemname','Staff');
		// $q->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
		$q->compare('t.firm_id',Yii::app()->user->firm_id);				

		$users = $paralegal = $user->findAll($q);

		// Uncomment the following line if AJAX validation is needed                
		//$this->performAjaxValidation($model);
                // ,$mprovider,$sprovider,$adjustor
                //$this->performAjaxValidation($model);
				if(isset($_POST['ajax']) && $_POST['ajax']==='casess-form'){
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
                $use = new User;
                $c = new CDbCriteria;
                $c->join = 'left join authassignment on authassignment.userid=t.id';
                $c->compare('authassignment.itemname','Client');
                $clis = $use->findAll($c);
                $this->writeLog = false;
                $cid='';$apdataprovider='';$aparties='';
				// var_dump(base64_decode(urldecode($C)));
		if(isset($_GET['ajax'])){
				if($_GET['ajax']=="adverse-party-grid"){
				$apdataprovider = new CActiveDataProvider('Adverseparty',array(
                        'criteria'=>array(
                            //'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            'condition'=>'t.case_id=\''.$_SESSION['current_case'].'\'',
                            'order'=>'t.created DESC',
                            // 'join'=>'LEFT JOIN authassignment ON authassignment.userid = t.id',
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('afaps' ),        
                            //'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>6,
                        ), 
				));
				// echo 'ok';
				$this->render('create',array(
			'model'=>$model,
			'usr'=>$usr,
			'cid'=>$cid,
			'contract'=>$contract,
			'probate'=>$probate,
			'criminal'=>$criminal,
			'apdataprovider'=>$apdataprovider,
			//'courts'=>$courts,
			'users'=>$users,
			'migrate'=>$migrate,
			'is_update'=>false,
			'caseinfo'=>$caseinfo,
			'counsel'=>$counsel,
			'ocapf'=>$ocapf,
			'ocei'=>$ocei,
			'selections'=>$selections,
			'aparty'=>$aparty,
			'afap'=>$afap,
			'apattorney'=>$apattorney,
			'ocedi'=>$ocedi,
			'ocapfc'=>$ocapfc,
			'casead'=>$casead,
			'courtinfo'=>$courtinfo,
			'adjustor'=>$adjustor,
			'ajax'=>'adverse-party-grid',
			'clis'=>$clis,
			'address'=>$address,
			'mprovider'=>$mprovider,
			'sprovider'=>$sprovider,
			'attorney'=>$attorney,
			'paralegal'=>$paralegal,
			'aparties'=>$aparties,
			'estate'=>$estate,
			'personal'=>$personal,
			'family'=>$family,
			'spouse'=>$spouse,
			'marital'=>$marital,
			'child'=>$child,
			'aat'=>$aat,
			'bsba'=>$bsba,
			'insurance'=>$insurance,
			'defendent'=>$defendent,
			'property'=>$property,
			'health'=>$health,
			'medical'=>$medical
		));
				Yii::app()->end();
				}
			}
		if(isset($_POST['Cases']) && !Yii::app()->request->isAjaxRequest){
			// var_dump($_POST);		
			if(isset($C)){
				$cl_id = base64_decode(urldecode($C));
				$_SESSION['client'] = $cl_id;
			}
			$clie = new Client;
			$cd = new CDbCriteria();
			$cdd = new CDbCriteria();
			$cdd->compare('id',$_SESSION['client']);
			$cd->compare('user_id',$_SESSION['client']);
			$clientss = $clie->find($cd);
			$clientsss = $clie->find($cdd);                         
			$model->attributes=$_POST['Cases'];
			$model->user_id = $clientss->id;
			// $model->usr = $_POST['']
			$ccusr =$_POST['CaseUser']['user_id'];
			// var_dump($_POST);			
			// foreach($_POST['CaseUser']['user_id'] as $ku=>$pcu){				
				// $ccusr[] = $pcu;
			// }
			// var_dump($_POST);
			// die();
			$model->usr = $ccusr;
			//$model->assigned_attorney = $_POST['Cases']['assigned_attorney'];
			// $model->assigned_staff = $_POST['Cases']['assigned_staff'];
			$model->case_type = $_POST['Cases']['case_type'];
			$model->nature_of_representation = $_POST['Cases']['nature_of_representation'];
			$model->statute_of_limitation = date('Y-m-d',strtotime($_POST['Cases']['statute_of_limitation']));
			$model->created_by = Yii::app()->user->id;
			$model->firm_id = $rft;
			$model->retainer_deposit = $_POST['Cases']['retainer_deposit'];
			$model->statue_applicable=$_POST['Cases']['statue_applicable'];
			
			
			//var_dump($model->save());
			// if(!isset($_POST['cid']) && !empty($_POST['cid']) && strlen($_POST['cid'])>=1){
			if( !isset($_POST['cid']) ){
				if($model->save()){
					$case_id = $model->primaryKey;
					if(isset($_POST['Cases']['assigned_staff'])){
						foreach($_POST['Cases']['assigned_staff'] as $u=>$c){
							$ur = new CaseUser;
							$ur->case_id = $case_id;
							$ur->user_id = $c;
							$ur->utype = "staff";
							$ur->save();
						}
					}
					if(count($_POST['CaseUser']['user_id'])>0)
					{
						foreach($_POST['CaseUser']['user_id'] as $u=>$c){
							$ur = new CaseUser;							
							$ur->case_id = $case_id;
							$ur->user_id = $c;							
							$ur->save();							
						}
					}
					$cid = $case_id;					
					$_SESSION['current_case'] = $cid;
					if(!is_null($cl_id)){
						$_SESSION['case'] = $cid;
						$_SESSION['case_name'] = $model->casenaam;
					}
					$uusr = new User;
					$uuq = new CDbcriteria;
					$uuq->join = "inner join case_user cu on cu.user_id = t.id inner join authassignment au on au.userid = t.id";
					$uuq->compare('cu.case_id',$cid);
					$uuq->compare('au.itemname','Admin');
					$uuq->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
					$selections = $uusr->findAll($uuq);
					// var_dump($selections);
					$calendar->alert_date = date('Y-m-d',strtotime($_POST['Cases']['statute_of_limitation']));
					$calendar->subject = 'Statue of Limitation';
					$calendar->description = 'Statue of Limitation :'.date('d-m-Y',strtotime($_POST['Cases']['statute_of_limitation'])).' of '.$_POST['Cases']['case_type'].' Case';
					$calendar->alert_type = 'Client';
					$calendar->to_client = '1';
					$calendar->created_by = Yii::app()->user->id;
					$calendar->notes = 'Statue of Limitation :'.date('d-m-Y',strtotime($_POST['Cases']['statute_of_limitation'])).' of '.$_POST['Cases']['case_type'].' Case';
					// $cal_user = array($_POST['Cases']['assigned_attorney']);
					$cal_user = $_POST['CaseUser']['user_id'];
					if(isset($_POST['Cases']['assigned_staff']) && !empty($_POST['Cases']['assigned_staff'])){
						array_push($cal_user,$_POST['Cases']['assigned_staff']);
					}
					// $calendar->user = $cal_user;					
					$calendar->case_id = $case_id;
					$calendar->save();
					$cal_id = $calendar->primaryKey;
					foreach($cal_user as $ck=>$cu){
						$cuu = new CalendarUser();
						$cuu->calendar_id = $cal_id;
						$cuu->user_id = $cu;						
						$cuu->save();
					}
					$this->writeLog = true;
					$this->logMessage = "New Case Created with details Case : ";
					$this->functionalArea = "Admin";
					$this->addLog();
					
					$usere = new User;
					$sq = new CDbCriteria;
					$sq->join = " left join case_user au on au.user_id = t.id";
					$sq->compare('au.case_id',$cid);
					// $sq->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
					$susr = $usere->findAll($sq);
					$selections= $susr;
					
					$usere = new User;
					$sq = new CDbCriteria;
					$sq->join = " left join case_user au on au.user_id = t.id";
					$sq->compare('au.case_id',$cid);					
					$sq->compare('au.utype','staff');					
					$susr = $usere->findAll($sq);
					$sselections= $susr;	
					//$this->redirect(array('admin'));
					//$this->render('ctype',array('case_id'=>$case_id));
					$apdataprovider = new CActiveDataProvider('Adverseparty',array(
                        'criteria'=>array(
                            //'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            'condition'=>'t.case_id=\''.$_POST['cid'].'\'',
                            'order'=>'t.created DESC',
                            // 'join'=>'LEFT JOIN authassignment ON authassignment.userid = t.id',
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('afaps' ),        
                            //'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>6,
                        ), 
                    ));
				}
			}else{
				$this->subCreate($_POST['cid']);				
				// die('assas');
				$model = $this->loadModel($_POST['cid']);
				$cid=$_POST['cid'];
				$apdataprovider = new CActiveDataProvider('Adverseparty',array(
                        'criteria'=>array(
                            //'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            'condition'=>'t.case_id=\''.$_POST['cid'].'\'',
                            'order'=>'t.created DESC',
                            // 'join'=>'LEFT JOIN authassignment ON authassignment.userid = t.id',
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('afaps' ),        
                            //'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>6,
                        ), 
                    ));
				$apar = new Adverseparty();
		$cd = new CDbCriteria();
		$cd->compare('t.case_id',$_POST['cid']);				
		$aparties = $apar->findAll($cd);
		// $sql = "SELECT *, concat(last_name,', ',first_name) as fullname from adverseparty where id not in (SELECT adverseparty.id as counter FROM `adverseparty` inner join afap on afap.adverseparty_id=adverseparty.id WHERE 1) and adverseparty.case_id='".$_POST['cid']."'";
		// $connection = Yii::app()->dynamicDb; 
		// $command = $connection->createCommand($sql);
		// $rowCount = $command->execute(); // execute the non-query SQL
		// $aparties = $command->query(); // execute a query SQL
		if(isset($_POST['Adverseparty'])){
			$apcount = $this->non_empty($_POST['Adverseparty']);
			// var_dump($apcount);
			if($apcount<15){				
			}else{
				$this->redirect(array('admin'));
			}
		}else{
			$this->redirect(array('admin'));
		}
			}
		}
		$this->render('create',array(
			'model'=>$model,
			'usr'=>$usr,
			'cid'=>$cid,
			'contract'=>$contract,
			'probate'=>$probate,
			'criminal'=>$criminal,
			'apdataprovider'=>$apdataprovider,
			//'courts'=>$courts,
			'users'=>$users,
			'migrate'=>$migrate,
			'is_update'=>false,
			'caseinfo'=>$caseinfo,
			'counsel'=>$counsel,
			'ocapf'=>$ocapf,
			'work'=>$work,
			'ocei'=>$ocei,
			'selections'=>$selections,
			'sselections'=>$sselections,
			'aparty'=>$aparty,
			'afap'=>$afap,
			'apattorney'=>$apattorney,
			'ocedi'=>$ocedi,
			'ocapfc'=>$ocapfc,
			'casead'=>$casead,
			'courtinfo'=>$courtinfo,
			'adjustor'=>$adjustor,
			'clis'=>$clis,
			'address'=>$address,
			'mprovider'=>$mprovider,
			'sprovider'=>$sprovider,
			'attorney'=>$attorney,
			'paralegal'=>$paralegal,
			'aparties'=>$aparties,
			'estate'=>$estate,
			'personal'=>$personal,
			'family'=>$family,
			'spouse'=>$spouse,
			'marital'=>$marital,
			'child'=>$child,
			'aat'=>$aat,
			'bsba'=>$bsba,
			'insurance'=>$insurance,
			'defendent'=>$defendent,
			'property'=>$property,
			'health'=>$health,
			'medical'=>$medical
		));
	}

        public function actionCtype(){
            $this->layout = 'logged';
            //var_dump($_POST);
            switch ($_POST['ctype']) {
                case 'contract':
                    $this->redirect('contract/cd/'.$_POST['case_id']);
                    break;
                case 'criminallaw':
                    $this->redirect('criminallaw/cd/'.$_POST['case_id']);
                    break;                
                case 'immigration':
                    $this->redirect('imigration/cd/'.$_POST['case_id']);
                    break;                
                case 'probate':
                    $this->redirect('probate/cd/'.$_POST['case_id']);
                    break;
                case 'familylaw':
                    $this->redirect('familylaw/cd/'.$_POST['case_id']);
                    break;
                case 'cetsprovider':
                    $this->redirect('cetsprovider/cd/'.$_POST['case_id']);
                    break;
                case 'realestate':
                    $this->redirect('realestate/cd/'.$_POST['case_id']);
                    break;
                case 'trustwill':
                    $this->redirect('trustwill/cd/'.$_POST['case_id']);
                    break;
                case 'familylaw':
                    $this->redirect('familylaw/cd/'.$_POST['case_id']);
                    break;                
                case 'worker':
                    $this->redirect('worker/cd/'.$_POST['case_id']);
                    break;                
                default:
                    //$this->redirect('imigration/cd/'.$_POST['case_id']);
                    break;
            }            
        }

        public function actionUpdate($id)

	{

		$model=$this->loadModel($id);

		//$model=new Cases;
		$this->layout="logged";
		$user = new User;
		$con=null;
		$court = new Court;
                $address = new Address;
		$counsel = new Counsel;
		$mprovider = new Mprovider;
		$sprovider = new Sprovider;
		$adjustor = new Adjustor;
		
		$courts = $court->findAll();
		
		$usr = new CaseUser;

		$q = new CDbCriteria();

		$q->compare('status','1');

                $q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';

                $q->compare('authassignment.itemname','Attorney');
                $q->compare('t.firm_id',Yii::app()->user->firm_id);

		$attorney = $user->findAll($q);
                
                $e = new CDbCriteria;
                $e->join = 'left join authassignment on authassignment.userid = t.user_id';
                $e->compare('case_id',$id);
                $e->compare('authassignment.itemname','Attorney');
                $att = $usr->findAll($e);
                
                $e = new CDbCriteria;
                $e->join = 'left join authassignment on authassignment.userid = t.user_id';
                $e->compare('case_id',$id);
                $e->compare('authassignment.itemname','Paralegal');
                $para = $usr->findAll($e);
                
                $cu = new CaseProvider;
                $u = new CDbCriteria;
                $u->compare('case_id',$id);
                $u->compare('provider_type','counsel');
                $con = $cu->findAll($u);
                
                
                $u = new CDbCriteria;
                $u->compare('case_id',$id);
                $u->compare('provider_type','adjustor');
                $cop = $cu->findAll($u);
                
                $u = new CDbCriteria;
                $u->compare('case_id',$id);
                $u->compare('provider_type','mprovider');
                $cor = $cu->findAll($u);
                
                
                $u = new CDbCriteria;
                $u->compare('case_id',$id);
                $u->compare('provider_type','sprovider');
                $col = $cu->findAll($u);

                $q = new CDbCriteria();

		$q->compare('status','1');

                $q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';

                $q->compare('authassignment.itemname','Paralegal');
                $q->compare('t.firm_id',Yii::app()->user->firm_id);

                $users = $paralegal = $user->findAll($q);

		// Uncomment the following line if AJAX validation is needed                
		//$this->performAjaxValidation($model);
                // ,$mprovider,$sprovider,$adjustor
                $this->performAjaxValidation(array($model,$counsel,$address,$mprovider,$sprovider,$adjustor,$address));


                $this->writeLog = false;



		if(isset($_POST['Cases']) && !Yii::app()->request->isAjaxRequest)

		{

			$model->attributes=$_POST['Cases'];
                        $model->statue_applicable=$_POST['Cases']['statue_applicable'];
			if($model->save()){

				$mod = new CaseUser();

				$q = new CDbCriteria();

				$q->compare('case_id',$id);

				$mod->deleteAll($q);

                                $this->writeLog = true;

                                $this->logMessage = "Case Updated with details Case : ".$_POST['Cases']['citation_no']."(".$_POST['Cases']['case_no'].")";

                                $this->functionalArea = "Admin";

                                $this->addLog();

				foreach($_POST['CaseUser'] as $cu){

					$mod = new CaseUser();
					$cu['case_id'] = $id;
					$mod->attributes = $cu;
					if($cu['user_id']!=0){
						$mod->save();
					}
				} 
                               if(isset($_POST['Counsel'])) foreach($_POST['Counsel'] as $key=>$co){
                                    $md = new Counsel;
                                    $ad = new Address;
                                    $cad = new CounselAddress;
                                    $mdd = new CaseProvider;
                                    
                                    if(isset($co['id'])){
                                        $aid = $_POST['Address']['Counsel'][$key]['id'];
                                        $cid = $co['id'];
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$cid);
                                        
                                        $md->deleteAll($o);
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$aid);                                        
                                        $ad->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('case_id',$id);
                                        //$o->compare('provider_id',$cid);
                                        $o->compare('provider_type','counsel');
                                        $mdd->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('counsel_id',$cid);
                                        $o->compare('address_id',$aid);                                        
                                        $cad->deleteAll($o);
                                        
                                        unset($co['id']);
                                        unset($_POST['Address']['Counsel'][$key]['id']);
                                    }
                                    
                                    $md->attributes = $co; 
                                    $md->created_by = $co['created_by'];                                    
                                    $md->save();
                                    
                                    
                                    $ad->attributes = $_POST['Address']['Counsel'][$key];
                                    $ad->save();
                                    
                                    $cad->address_id = $ad->primaryKey;
                                    $cad->counsel_id = $md->primaryKey;
                                    $cad->save();
                                    
                                    $mdd->case_id = $id;
                                    $mdd->provider_id = $md->primaryKey;
                                    $mdd->provider_type = "counsel";
                                    $mdd->save();
                                    
                        }}
                              if(isset($_POST['Adjustor'])){  foreach($_POST['Adjustor'] as $key=>$co){
                                    $md = new Adjustor;
                                    $ad = new Address;
                                    $cad = new AdjustorAddress;
                                    $mdd = new CaseProvider;
                                    
                                    if(isset($co['id'])){
                                        $aid = $_POST['Address']['Adjustor'][$key]['id'];
                                        $cid = $co['id'];
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$aid);                                        
                                        $ad->deleteAll($o);
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$cid);
                                        $md->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('case_id',$id);
                                       // $o->compare('provider_id',$cid);
                                        $o->compare('provider_type','adjustor');
                                        $mdd->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('adjustor_id',$cid);
                                        $o->compare('address_id',$aid);                                        
                                        $cad->deleteAll($o);
                                        
                                        unset($co['id']);
                                        unset($_POST['Address']['Adjustor'][$key]['id']);
                                    }
                                    
                                    $md->attributes = $co;
                                    $md->created_by = $co['created_by'];
                                    $md->save();
                                    
                                    $ad->attributes = $_POST['Address']['Adjustor'][$key];
                                    $ad->save();
                                    
                                    $cad->address_id = $ad->primaryKey;
                                    $cad->adjustor_id = $md->primaryKey;
                                    $cad->save();
                                    
                                    $mdd->case_id = $id;
                                    $mdd->provider_id = $md->primaryKey;
                                    $mdd->provider_type = "adjustor";
                                    $mdd->save();
                        }}
                                if(isset($_POST['Mprovider'])){  foreach($_POST['Mprovider'] as $key=>$co){
                                    $md = new Mprovider;
                                    $ad = new Address;
                                    $mdd = new CaseProvider;
                                    $cad = new MproviderAddress;
                                    
                                    if(isset($co['id'])){
                                        $aid = $_POST['Address']['Mprovider'][$key]['id'];
                                        $cid = $co['id'];
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$aid);                                        
                                        $ad->deleteAll($o);
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$cid);
                                        $md->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('case_id',$id);
                                       // $o->compare('provider_id',$cid);
                                        $o->compare('provider_type','mprovider');
                                        $mdd->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('mprovider_id',$cid);
                                        $o->compare('address_id',$aid);                                        
                                        $cad->deleteAll($o);
                                        
                                        unset($co['id']);
                                        unset($_POST['Address']['Mprovider'][$key]['id']);
                                    }
                                    
                                    $md->attributes = $co;
                                    $md->created_by = $co['created_by'];
                                    $md->save();
                                    
                                    $ad->attributes = $_POST['Address']['Mprovider'][$key];
                                    $ad->save();
                                    
                                    $cad->address_id = $ad->primaryKey;
                                    $cad->mprovider_id = $md->primaryKey;
                                    $cad->save();
                                    
                                    $mdd->case_id = $id;
                                    $mdd->provider_id = $md->primaryKey;
                                    $mdd->provider_type = "mprovider";
                                    $mdd->save();
                        }}
                               if(isset($_POST['Sprovider'])){ foreach($_POST['Sprovider'] as $key=>$co){
                                    $md = new Sprovider;                                    
                                    $ad = new Address;
                                    $cad = new SproviderAddress;
                                    $mdd = new CaseProvider;
                                    
                                    if(isset($co['id'])){
                                        $aid = $_POST['Address']['Sprovider'][$key]['id'];
                                        $cid = $co['id'];
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$aid);                                        
                                        $ad->deleteAll($o);
                                        
                                        $o = new CDbCriteria;                                        
                                        $o->compare('id',$cid);
                                        $md->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('case_id',$id);
                                        //$o->compare('provider_id',$cid);
                                        $o->compare('provider_type','sprovider');
                                        $mdd->deleteAll($o);
                                        
                                        $o = new CDbCriteria;
                                        $o->compare('sprovider_id',$cid);
                                        $o->compare('address_id',$aid);                                        
                                        $cad->deleteAll($o);
                                        
                                        unset($co['id']);
                                        unset($_POST['Address']['Sprovider'][$key]['id']);
                                    }
                                    
                                    $md->attributes = $co;
                                    $md->created_by = $co['created_by'];
                                    $md->save();
                                    
                                    $ad->attributes = $_POST['Address']['Sprovider'][$key];
                                    $ad->save();
                                    
                                    $cad->address_id = $ad->primaryKey;
                                    $cad->sprovider_id = $md->primaryKey;
                                    $cad->save();
                                    
                                    $mdd->case_id = $id;
                                    $mdd->provider_id = $md->primaryKey;
                                    $mdd->provider_type = "sprovider";
                                    $mdd->save();
                        }}
				// $this->redirect(array('view','id'=>$model->id));
                                
				$this->redirect(array('admin'));

			}

			

		

		$mode = new CaseUser();

		$q=new CDbCriteria() ;

		$q->compare("t.case_id",$id);

		$q->select=" t.user_id ,t.hourly_rate,user.username";

		$q->join=" left join authassignment ON authassignment.userid=t.user_id left join `user`  on `user`.id=t.user_id";

		 $q->compare("authassignment.itemname","Attorney");

		 $attr=$mode->findall($q);

		//$attr = array();

		$mode = new CaseUser();

		$q=new CDbCriteria() ;

		$q->compare("t.case_id",$id);

		$q->select=" t.user_id ,t.hourly_rate,user.username";

		$q->join=" left join authassignment ON authassignment.userid=t.user_id left join `user`  on `user`.id=t.user_id";

		

		$q->compare("authassignment.itemname","Paralegal");

		$para=$mode->findall($q);

		//echo $q;

//var_dump($q);

		$this->render('update',array(
			'model'=>$model,
			'usr'=>$usr,
			'courts'=>$courts,
			'users'=>$users,
			'counsel'=>$counsel,
                        'att'=>$att,
                        'para'=>$para,
                        'con'=>$con,
                        'cop'=>$cop,
                        'cor'=>$cor,
                        'col'=>$col,
			'adjustor'=>$adjustor,
                        'address'=>$address,
			'mprovider'=>$mprovider,
			'sprovider'=>$sprovider,
			'attorney'=>$attorney,
			'paralegal'=>$paralegal,
		));

	}



	/**

	 * Updates a particular model.

	 * If update is successful, the browser will be redirected to the 'view' page.

	 * @param integer $id the ID of the model to be updated

	 */

	 

	// public function actionUpdateaaa($id)

	// {

		// $model=$this->loadModel($id);



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		// if(isset($_POST['Cases']))

		// {

			// $model->attributes=$_POST['Cases'];

			// if($model->save())

				// $this->redirect(array('view','id'=>$model->id));

		// }



		// $this->render('update',array(

			// 'model'=>$model,

		// ));

	// }



	/**

	 * Deletes a particular model.

	 * If deletion is successful, the browser will be redirected to the 'admin' page.

	 * @param integer $id the ID of the model to be deleted

	 */

	public function actionDelete($id)

	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$cs = new Cases();

                $q = new CDbCriteria;

                $q->compare('id',$id);

                $cas = $cs->find($q);

                $this->writeLog = true;

                // $this->logMessage = "Case Deleted with details Case : ".$cas->citation_no."(".$cas->case_no.")";
                $this->logMessage = "Case Deleted with details Case : ".$cas->id."";

                $this->functionalArea = "Admin";

                //$this->addLog();

                

                $this->loadModel($id)->delete();                

                

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser

		if(!isset($_GET['ajax']))

			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));

	}

	
	public function actionUnarchive($id) {
		// $ft = User::model()->getUtype($id);			
		// $qu = "select count(t.id) as no from cases t left join case_user cu on cu.case_id=t.id where cu.user_id='".$id."'";
		// $list= Yii::app()->db->createCommand($qu)->queryAll();
		// $rs=0;
		// foreach($list as $item){
			// $rs = $item['no'];
		// }
		// if($rs>0){
			// Yii::app()->user->setFlash('message','User is Assigned to Cases, please un-assign user from cases to proceed.');
			// $this->redirect(Yii::app()->request->urlReferrer);
			// Yii::app()->end();
		// }			
		Cases::model()->updateByPk($id,array('is_closed'=>'0'));
		Yii::app()->user->setFlash('message','Case Unarchived successfully.');
		$this->redirect(Yii::app()->request->urlReferrer);
	}
	
	
	public function actionArchive($id) {
			$ft = User::model()->getUtype($id);
			// if(array_search('Client',$ft)!==false){
				$qu = "select count(t.id) as no from cinvoice t where (t.amount-t.paid)>0 and t.case_id='".$id."'";
				$list= Yii::app()->db->createCommand($qu)->queryAll();
				$rs=0;
				foreach($list as $item){
					$rs = $item['no'];
				}
				if($rs>0){
					Yii::app()->user->setFlash('message','Case has pending Invoices. Please clear those to close this case.');
					$this->redirect(Yii::app()->request->urlReferrer);
					Yii::app()->end();
				}
			// }
			// $uu = User::model()->findByPk($id);
			Cases::model()->updateByPk($id,array('is_closed'=>'1'));
			Yii::app()->user->setFlash('message','Case archived successfully.');
			// $this->toMainDb();
			// $c= new CDbCriteria;
			// $c->compare('email',$uu->email);
			// $u = User::model()->find($c);			
			// $u->is_active = '0';
			// $u->password = $uu->password;
			// $u->password2 = $uu->password;
			// $u->save();
			// if($u->hasErrors()){
				// echo CHtml::errorSummary($u);
			// }			
			$this->redirect(Yii::app()->request->urlReferrer);
	}
	

	/**

	 * Lists all models.

	 */

	public function actionIndex(){

		$this->writeLog = false;
		$this->redirect('case/admin');
		$dataProvider=new CActiveDataProvider('Cases');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
	/**

	 * Manages all models.

	 */
        
        public function actionAccount()
	{

                $this->writeLog = false;
                $this->layout='logged';                
                //var_dump($_POST);
                if(isset($_POST['Invo']) || isset($_POST['Exp'])){
                    $cinv = new Cinvoice;
                    $cinv->created_by = Yii::app()->user->id;
                    $cinv->slug = uniqid();
                    $cinv->client_id = $_SESSION['client'];
                    //$cinv->invoices = $_POST['Invo'];
					$fgg=array();
					if(isset($_POST['Invo'])){
						$cinv->invoices = $_POST['Invo'];						
						foreach($_POST['Invo'] as $ex){
							$inv1 = new Invoice();
							$cd = new CDbCriteria();
							$cd->compare('t.id',$ex);
							$df1 = $inv1->find($cd);
							$fgg[$df1->case_id]=$df1->case_id;
                            Invoice::model()->updateByPK($ex,array('to_invoice'=>'1'));
                        }
					}
                    if(isset($_POST['Exp'])){
                        $cinv->expenses = $_POST['Exp'];
                        foreach($_POST['Exp'] as $ex){
							$inv1 = new Expense();
							$cd = new CDbCriteria();
							$cd->compare('t.id',$ex);
							$df1 = $inv1->find($cd);
							$fgg[$df1->case_id]=$df1->case_id;
                            Expense::model()->updateByPK($ex,array('to_invoice'=>'1'));
                        }
                    }
                    $ft='';
                    if(isset($_POST['Invo'])){
						$ft = implode(',',$_POST['Invo']);      
					}
					$ftt="";
					if(isset($_POST['Exp'])){
						$ftt = implode(',',$_POST['Exp']);
					}
					if(count($fgg)>=1){
						$cinv->cases = $fgg;
					}
                    if($cinv->save()){
						$ttr=0;
						if(isset($_POST['Invo'])){
							$query = "SELECT sum( invoice.unit * invoice.unit_price ) AS tot
                                FROM `invoice`
                                INNER JOIN invoice_cinvoice ON invoice_cinvoice.invoice_id = invoice.id
                                INNER JOIN cinvoice ON cinvoice.id = invoice_cinvoice.cinvoice_id where invoice.id in (".$ft.")";
							$ff = Yii::app()->db->createCommand($query)->queryRow();
							$ttr+=$ff['tot'];
						}
						if(isset($_POST['Exp'])){
							$querya = "SELECT sum( expense.amount ) AS tot
                                FROM `expense`
                                INNER JOIN expense_cinvoice ON expense_cinvoice.expense_id = expense.id
                                INNER JOIN cinvoice ON cinvoice.id = expense_cinvoice.cinvoice_id where expense.id in (".$ftt.")";
							$fff = Yii::app()->db->createCommand($querya)->queryRow();                      
							$ttr+=$fff['tot'];
						}                       
						$cid = $cinv->primaryKey;
						Cinvoice::model()->updateByPk($cid,  array('amount'=>$ttr));
                        //$this->redirect(array('case/caccount'));                       
                        $this->redirect(array('case/viewi/'.$cinv->primaryKey));
                    }
                }
                //var_dump($_SESSION['client']);
				$dataProvider=new CActiveDataProvider('Cases',array(
                    'criteria'=>array(
                        'condition'=>'user_id='.$_SESSION['client'],
                        //'order'=>'create_time DESC',
                        //'with'=>array('author'),
                     ),
                    'pagination' => array(
                        'pageSize' => 2,
                    ),
                ));
		
		$this->render('account',array(

			'dataProvider'=>$dataProvider,

		));

	}		
    public function actionUpdateClaccount()
	{    $this->dbswitch(Yii::app()->user->firm_id);
                $this->writeLog = false;
                $this->layout='newd1'; 
$slug=$_REQUEST['slug'];				
if(isset($_POST['typer'])){
					$datae = (array)json_decode($_POST['datt']);
					$ci = new Cinvoice;
					$c = new CDbCriteria;
					$c->compare('t.slug',$slug);
					$cinv = $ci->find($c);
					//$cinv = new Cinvoice;
                    $cinv->created_by = Yii::app()->user->id;
                    $cinv->slug = $_POST['slug'];
                    $cinv->client_id = $_SESSION['client'];					
                    $cinv->case_id = $_SESSION['case'];					
                    $cinv->amount = $_POST['total'];					
                    $cinv->paid = $_POST['amount_paid'];					
                    $cinv->notes = $_POST['inote'];
                    $cinv->balance = $_POST['balance'];	
                    $cinv->invoice_date = $_POST['idate'];
                    $cinv->due_date = $_POST['ddate'];
                    $cinv->to_address = $_POST['to_address'];
                    $cinv->from_address = $_POST['from_address'];
					if($_POST['balance']>0 && $_POST['balance']<$_POST['total']){
						$cinv->status = "Partial";
					}
					if($_POST['balance']==0){
						$cinv->status = "Paid";
					}
					if($_POST['amount_paid']==0){
						$cinv->status = "Unpaid";
					}
					$ft='';
                    // if(isset($_POST['Invo'])){
						// $ft = implode(',',$_POST['Invo']);      
					// }
					// $ftt="";
					// if(isset($_POST['Exp'])){
						// $ftt = implode(',',$_POST['Exp']);
					// }
                    if($cinv->save()){
						// die();
						$cpk = $cinv->primaryKey;
						// Cinvoice::model()->updateByPK($cpk,array('amount'=>$_POST['total']));
						$ttr=0;
						/*
						if(isset($_POST['Invo'])){
							$query = "SELECT sum( invoice.unit * invoice.unit_price ) AS tot
                                FROM `invoice`
                                INNER JOIN invoice_cinvoice ON invoice_cinvoice.invoice_id = invoice.id
                                INNER JOIN cinvoice ON cinvoice.id = invoice_cinvoice.cinvoice_id where invoice.id in (".$ft.")";
							$ff = Yii::app()->db->createCommand($query)->queryRow();
							$ttr+=$ff['tot'];
						}
						if(isset($_POST['Exp'])){
							$querya = "SELECT sum( expense.amount ) AS tot
                                FROM `expense`
                                INNER JOIN expense_cinvoice ON expense_cinvoice.expense_id = expense.id
                                INNER JOIN cinvoice ON cinvoice.id = expense_cinvoice.cinvoice_id where expense.id in (".$ftt.")";
							$fff = Yii::app()->db->createCommand($querya)->queryRow();                      
							$ttr+=$fff['tot'];
						} */ 						
						$cid = $cinv->primaryKey;
						if(isset($datae['Invo'])){
							$cinv->invoices = $datae['Invo'];
							foreach($datae['Invo'] as $ex){
								Invoice::model()->updateByPK($ex,array('to_invoice'=>'1'));
								Invoice::model()->updateByPK($ex,array('cinvoice_id'=>$cid));
							}
						}
						if(isset($datae['Exp'])){
							$cinv->expenses = $datae['Exp'];
							foreach($datae['Exp'] as $ex){
								Expense::model()->updateByPK($ex,array('to_invoice'=>'1'));
								Expense::model()->updateByPK($ex,array('cinvoice_id'=>$cid));
							}
						}
						// Cinvoice::model()->updateByPk($cid,  array('amount'=>$ttr));
                        $this->redirect(array('case/caccount'));                       
                        //$this->redirect(array('case/viewi/'.$cinv->primaryKey));
                    }
					// die();
					Yii::app()->end();
				}				
               if(!is_null($_REQUEST['slug'])){
			   
					$ci = new Cinvoice;
					$c = new CDbCriteria;
					$c->compare('t.slug',$slug);
					$d = $ci->find($c);
					$datas = array();$counter=0;	$datass = array();	
					
					/*foreach($d->invoices as $inn){
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Billing/Time Entry";
						$counter++;
					}
					foreach($d->expenses as $inn){
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Expense";
						$counter++;
					}
					 */
					 if(!is_null($d->invoices)){
					foreach($d->invoices as $val){
					//foreach($_POST['Invo'] as $key=>$val){
						$inv = new Invoice;
						$cd = new CDbCriteria;
						$cd->compare('t.id',$val->id);
						$inn = $inv->find($cd);
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Billing/Time Entry";
						$counter++;
					}
					}
					//var_dump($d->expenses);
					if(!is_null($d->expenses)){
						foreach($d->expenses as $val){
						//foreach($_POST['Exp'] as $key=>$val)
							$inv = new Expense;
							$cd = new CDbCriteria;
							$cd->compare('t.id',$val->id);
							$inn = $inv->find($cd);
							$datas[$counter] = $inn;
							$datass[$counter]['type']="Expense";
							$counter++;
						}
					}
				
		//if(isset($_REQUEST['Invo']) || isset($_REQUEST['Exp'])){
					
					$usr = new User;
					$cli = new Client;
					$cdd = new CDbCriteria;
					$cdd->compare('t.id',Yii::app()->user->id);
					$lusr = $usr->find($cdd);					
					$cdd = new CDbCriteria;
					$cdd->compare('t.id',$_SESSION['client']);
					$lcli = $usr->find($cdd);
					//$datas = array();$counter=0;	$datass = array();	
					
					$this->render('updateinvoice',array(
						'data'=>$_REQUEST,
						'to'=>$lcli,
						'from'=>$lusr,
						'datas'=>$datas,
						'datass'=>$datass,
						'slug'=>$_REQUEST['slug'],
						'cinvoice'=>$d,
					));
					Yii::app()->end();
				 
                }
	}
	public function actionClaccount($slug=null)
	{
			$this->dbswitch(Yii::app()->user->firm_id);
                $this->writeLog = false;
                $this->layout='newd1';                
               
				if(isset($_POST['typer'])){
					$datae = (array)json_decode($_POST['datt']);
					$cinv = new Cinvoice;
                    $cinv->created_by = Yii::app()->user->id;
                    $cinv->slug = $_POST['slug'];
                    $cinv->client_id = $_SESSION['client'];					
                    $cinv->case_id = $_SESSION['case'];					
                    $cinv->amount = $_POST['total'];					
                    $cinv->paid = $_POST['amount_paid'];					
                    $cinv->notes = $_POST['inote'];
                    $cinv->balance = $_POST['balance'];	
                    $cinv->invoice_date = $_POST['idate'];
                    $cinv->due_date = $_POST['ddate'];
                    $cinv->to_address = $_POST['to_address'];
                    $cinv->from_address = $_POST['from_address'];
					if($_POST['balance']>0 && $_POST['balance']<$_POST['total']){
						$cinv->status = "Partial";
					}
					if($_POST['balance']==0){
						$cinv->status = "Paid";
					}
					if($_POST['amount_paid']==0){
						$cinv->status = "Unpaid";
					}
					$ft='';
                    // if(isset($_POST['Invo'])){
						// $ft = implode(',',$_POST['Invo']);      
					// }
					// $ftt="";
					// if(isset($_POST['Exp'])){
						// $ftt = implode(',',$_POST['Exp']);
					// }
                    if($cinv->save()){
						// die();
						$cpk = $cinv->primaryKey;
						// Cinvoice::model()->updateByPK($cpk,array('amount'=>$_POST['total']));
						$ttr=0;
						/*
						if(isset($_POST['Invo'])){
							$query = "SELECT sum( invoice.unit * invoice.unit_price ) AS tot
                                FROM `invoice`
                                INNER JOIN invoice_cinvoice ON invoice_cinvoice.invoice_id = invoice.id
                                INNER JOIN cinvoice ON cinvoice.id = invoice_cinvoice.cinvoice_id where invoice.id in (".$ft.")";
							$ff = Yii::app()->db->createCommand($query)->queryRow();
							$ttr+=$ff['tot'];
						}
						if(isset($_POST['Exp'])){
							$querya = "SELECT sum( expense.amount ) AS tot
                                FROM `expense`
                                INNER JOIN expense_cinvoice ON expense_cinvoice.expense_id = expense.id
                                INNER JOIN cinvoice ON cinvoice.id = expense_cinvoice.cinvoice_id where expense.id in (".$ftt.")";
							$fff = Yii::app()->db->createCommand($querya)->queryRow();                      
							$ttr+=$fff['tot'];
						} */ 						
						$cid = $cinv->primaryKey;
						if(isset($datae['Invo'])){
							$cinv->invoices = $datae['Invo'];
							foreach($datae['Invo'] as $ex){
								Invoice::model()->updateByPK($ex,array('to_invoice'=>'1'));
								Invoice::model()->updateByPK($ex,array('cinvoice_id'=>$cid));
							}
						}
						if(isset($datae['Exp'])){
							$cinv->expenses = $datae['Exp'];
							foreach($datae['Exp'] as $ex){
								Expense::model()->updateByPK($ex,array('to_invoice'=>'1'));
								Expense::model()->updateByPK($ex,array('cinvoice_id'=>$cid));
							}
						}
						// Cinvoice::model()->updateByPk($cid,  array('amount'=>$ttr));
                        $this->redirect(array('case/caccount'));                       
                        //$this->redirect(array('case/viewi/'.$cinv->primaryKey));
                    }
					// die();
					Yii::app()->end();
				}
                if(!is_null($slug)){
					$ci = new Cinvoice;
					$c = new CDbCriteria;
					$c->compare('t.slug',$slug);
					$d = $ci->find($c);
					$datas = array();$counter=0;	$datass = array();	
					
					foreach($d->invoices as $inn){
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Billing/Time Entry";
						$counter++;
					}
					foreach($d->expenses as $inn){
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Expense";
						$counter++;
					}
					// $this->render('createinvoice',array(
						// 'data'=>$_POST,
						// 'to'=>$lcli,
						// 'from'=>$lusr,
						// 'datas'=>$datas,
						// 'datass'=>$datass,
						// 'slug'=>uniqid(),
					// ));
					// Yii::app()->end();
				}
				if(isset($_POST['Invo']) || isset($_POST['Exp'])){
					
					$usr = new User;
					$cli = new Client;
					$cdd = new CDbCriteria;
					$cdd->compare('t.id',Yii::app()->user->id);
					$lusr = $usr->find($cdd);					
					$cdd = new CDbCriteria;
					$cdd->compare('t.id',$_SESSION['client']);
					$lcli = $usr->find($cdd);
					$datas = array();$counter=0;	$datass = array();	
					if(isset($_POST['Invo'])){
					foreach($_POST['Invo'] as $key=>$val){
						$inv = new Invoice;
						$cd = new CDbCriteria;
						$cd->compare('t.id',$val);
						$inn = $inv->find($cd);
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Billing/Time Entry";
						$counter++;
					}
					}
					if(isset($_POST['Exp'])){
					foreach($_POST['Exp'] as $key=>$val){
						$inv = new Expense;
						$cd = new CDbCriteria;
						$cd->compare('t.id',$val);
						$inn = $inv->find($cd);
						$datas[$counter] = $inn;
						$datass[$counter]['type']="Expense";
						$counter++;
					}
					}
					$this->render('createinvoice',array(
						'data'=>$_POST,
						'to'=>$lcli,
						'from'=>$lusr,
						'datas'=>$datas,
						'datass'=>$datass,
						'slug'=>uniqid(),
					));
					Yii::app()->end();
					/*
                    $cinv = new Cinvoice;
                    $cinv->created_by = Yii::app()->user->id;
                    $cinv->slug = uniqid();
                    $cinv->client_id = $_SESSION['client'];
					if(isset($_POST['Invo'])){
						$cinv->invoices = $_POST['Invo'];
						foreach($_POST['Invo'] as $ex){
                            Invoice::model()->updateByPK($ex,array('to_invoice'=>'1'));
                        }
					}
                    if(isset($_POST['Exp'])){
                        $cinv->expenses = $_POST['Exp'];
                        foreach($_POST['Exp'] as $ex){
                            Expense::model()->updateByPK($ex,array('to_invoice'=>'1'));
                        }
                    }
					$ft='';
                    if(isset($_POST['Invo'])){
						$ft = implode(',',$_POST['Invo']);      
					}
					$ftt="";
					if(isset($_POST['Exp'])){
						$ftt = implode(',',$_POST['Exp']);
					}
                    if($cinv->save()){
						$ttr=0;
						if(isset($_POST['Invo'])){
							$query = "SELECT sum( invoice.unit * invoice.unit_price ) AS tot
                                FROM `invoice`
                                INNER JOIN invoice_cinvoice ON invoice_cinvoice.invoice_id = invoice.id
                                INNER JOIN cinvoice ON cinvoice.id = invoice_cinvoice.cinvoice_id where invoice.id in (".$ft.")";
							$ff = Yii::app()->db->createCommand($query)->queryRow();
							$ttr+=$ff['tot'];
						}
						if(isset($_POST['Exp'])){
							$querya = "SELECT sum( expense.amount ) AS tot
                                FROM `expense`
                                INNER JOIN expense_cinvoice ON expense_cinvoice.expense_id = expense.id
                                INNER JOIN cinvoice ON cinvoice.id = expense_cinvoice.cinvoice_id where expense.id in (".$ftt.")";
							$fff = Yii::app()->db->createCommand($querya)->queryRow();                      
							$ttr+=$fff['tot'];
						}                       
						$cid = $cinv->primaryKey;
						Cinvoice::model()->updateByPk($cid,  array('amount'=>$ttr));
                        //$this->redirect(array('case/caccount'));                       
                        //$this->redirect(array('case/viewi/'.$cinv->primaryKey));
                    }
					*/
                }
            	if($_SESSION['dashboard_type']=='Admin'){
					$dataProvider=new CActiveDataProvider('Cases',array(
                    'criteria'=>array(
                     ),
                    'pagination' => array(
                        'pageSize' => 2,
                    ),
					));
				}elseif($_SESSION['dashboard_type']=='Client'){
					if(isset($_SESSION['case'])){
						$dataProvider=new CActiveDataProvider('Cases',array(
							'criteria'=>array(
								// 'join' => 'LEFT JOIN client b ON b.id = t.user_id LEFT JOIN users u on u.id=b.user_id',
								'condition'=>'t.id='.$_SESSION['case'],
								//'order'=>'create_time DESC',
								//'with'=>array('author'),
							 ),
							'pagination' => array(
								'pageSize' => 2,
							),
						));
					}else{
						Yii::app()->user->setFlash('error','Please select a Case to proceed.');
						$this->redirect('user/dashboard');
					}
				}
				
		
		$this->render('account1',array(

			'dataProvider'=>$dataProvider,

		));

	}
        
        public function actionCidata(){
            $this->writeLog = false;
            $this->layout="logged";
            $model = new Transaction;
            $cinvoice = new Cinvoice;
            
            $dataProvider=new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        'condition'=>'client_id='.$_SESSION['client'],
                        //'order'=>'create_time DESC',
                        //'with'=>array('author'),
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
            $this->render('cidata',array('dataProvider'=>$dataProvider,'model'=>$model));
            
        }
        
	public function actionCaccount()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->writeLog = false;
		$this->layout='newd1';
		// $model=new Cinvoice('search');
		$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        'condition'=>'client_id='.$_SESSION['client'].' and is_draft=1 and balance != 0',
                        //'order'=>'create_time DESC',
                        //'with'=>array('author'),
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));

		// $model->unsetAttributes();  // clear any default values

		// if(isset($_GET['Cinvoice']))
			// $model->attributes=$_GET['Cinvoice'];

		$this->render('caccount',array(
			'model'=>$model,
		));

	} 
	
	public function actionLista()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->writeLog = false;
		$this->layout='newd1';
		$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'1=1 and balance != 0',
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
		$modelp = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'1=1 and balance = 0 and to_admin_archive=0',
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));

		$this->render('lista',array(
			'model'=>$model,
			'modelp'=>$modelp,
		));

	}

		public function actionPendingInvoices()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->writeLog = false;
		$this->layout='newd1';
		if($_SESSION['dashboard_type']=='Client')
		{
			$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'(balance>0 or paid=0) and client_id='.$_SESSION['client'],
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
		}
		else
		{
		$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'balance>0 or paid=0',
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
		}
		$this->render('pending_invoices',array(
			'model'=>$model,
		));

	}
	public function actionPaidInvoices()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->writeLog = false;
		$this->layout='newd1';
		if($_SESSION['dashboard_type']=='Client')
		{
			$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'amount=paid and client_id='.$_SESSION['client'],
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
		}
		else
		{
		$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        // 'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        'condition'=>'amount=paid',
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));
		}
		$this->render('paid_invoices',array(
			'model'=>$model,
		));

	}
		public function actionDaccount()
	{
		$this->dbswitch(Yii::app()->user->firm_id);
		$this->writeLog = false;
		$this->layout='newd1';
		// $model=new Cinvoice('search');
		$model = new CActiveDataProvider('Cinvoice',array(
                    'criteria'=>array(
                        'condition'=>'client_id='.$_SESSION['client'].' and is_draft=0',
                        //'order'=>'create_time DESC',
                        //'with'=>array('author'),
                     ),
                    'pagination' => array(
                        'pageSize' => 10,
                    ),
                ));

		// $model->unsetAttributes();  // clear any default values

		// if(isset($_GET['Cinvoice']))
			// $model->attributes=$_GET['Cinvoice'];

		$this->render('daccount',array(
			'model'=>$model,
		));

	}

	public function actionAdmin(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$roles=Rights::getAssignedRoles(Yii::app()->user->Id); // check for single role
		foreach($roles as $role)
		if($role->name == 'Admin')
		{
			$_SESSION['is_admin'] = true;
			//die('asdsd');
		}
		$this->writeLog = false;
		$this->layout='newd1';
		$model=new Cases('search');

		$model->unsetAttributes();  // clear any default values
		$dataprovider = new CActiveDataProvider('Cases',array(
                        'criteria'=>array(
							// 'select' => '*',
                            // 'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            'condition'=>"t.is_closed=0",
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            // 'condition'=>'t.case_id=\''.$id.'\'',
                            'order'=>'t.created DESC',                            
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('client' ), 
                            'with'=>array('attorney' ), 
                            // 'with'=>array('staff' ), 
							'join'=>'LEFT JOIN client cl ON cl.id = t.user_id LEFT JOIN users ON users.id = cl.user_id ',
                            //'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>10,
                        ), 
                    ));	
		if(isset($_GET['Cases']))

			$model->attributes=$_GET['Cases'];



		$this->render('admin',array(

			'model'=>$model,
			'dataprovider'=>$dataprovider

		));

	}

	
	public function actionAdmina(){
		$this->dbswitch(Yii::app()->user->firm_id);
		$roles=Rights::getAssignedRoles(Yii::app()->user->Id); // check for single role
		foreach($roles as $role)
		if($role->name == 'Admin')
		{
			$_SESSION['is_admin'] = true;
			//die('asdsd');
		}
		$this->writeLog = false;
		$this->layout='newd1';
		$model=new Cases('search');
		$model->unsetAttributes();  // clear any default values
		$dataprovider = new CActiveDataProvider('Cases',array(
                        'criteria'=>array(
                            'condition'=>"t.is_closed=1",
                            'order'=>'t.created DESC',
                            'with'=>array('client' ), 
                            'with'=>array('attorney' ), 
							'join'=>'LEFT JOIN client cl ON cl.id = t.user_id LEFT JOIN users ON users.id = cl.user_id ',
                        ),
                        'pagination'=>array(
                            'pageSize'=>10,
                        ), 
                    ));	
		if(isset($_GET['Cases']))
			$model->attributes=$_GET['Cases'];

		$this->render('admina',array(
			'model'=>$model,
			'title'=>'Closed Cases',
			'dataprovider'=>$dataprovider
		));
	}


	/**

	 * Returns the data model based on the primary key given in the GET variable.

	 * If the data model is not found, an HTTP exception will be raised.

	 * @param integer $id the ID of the model to be loaded

	 * @return Cases the loaded model

	 * @throws CHttpException

	 */

	public function loadModel($id)

	{

		$model=Cases::model()->findByPk($id);

		if($model===null)

			throw new CHttpException(404,'The requested page does not exist.');

		return $model;

	}



	/**

	 * Performs the AJAX validation.

	 * @param Cases $model the model to be validated

	 */

	protected function performAjaxValidation($model)

	{

		if(isset($_POST['ajax']) && $_POST['ajax']==='cases-form')

		{

			echo CActiveForm::validate($model);

			Yii::app()->end();

		}

	}
public function actionCaseProfile($id = null){
		// $this->layout="admin";
		$this->layout="newd1";
		$this->dbswitch(Yii::app()->user->firm_id);		
		// $model = $this->loadModel($id);
		if(is_null($id))
			$id=$_SESSION['case'];
		$model = Cases::model()->findByPk($id);
		$user = new User;		
		$ocei = new Ocei;
		$ocedi = new Ocedi;
		$casead = new Casead;
		$courtinfo = new Courtinfo;
		$aparty = new Adverseparty;
		$afap = new Afap;	
		$apattorney = new AfapAttorney;
		$contract = new Casecontract;
		$probate = new Probateinfo;
		$criminal=new Criminallaw;
		$migrate = new Imigrationinfo;
		$courtinfo = new Courtinfo();
		$estate = new Realestateinfo;
		$personal = new Personalinjury();
		$family = new Familylaw();
		$spouse = new Spouseinfo();
		$marital = new Maritalinfo();
		$child = new Childreninfo();
		$childd = '';
		$bsba = new Bsbainfo();
		$insurance = new Insuranceca;
		$defendent = new Defendentautoinfo;
		$property = new Propertydamage;
		$health = new Healthins;
		$medical = new Medicalsprovider;
		$medicals=$defendents='';
		$aat = new CaseUser;  
		$apattorneys='';
		$selections='';
		$sselections='';
		$sq = new CDbCriteria;
		$sq->join = " left join authassignment au on au.userid = t.id";
		// $sq->compare('au.itemname','Admin');
		$sq->addCondition("au.itemname = 'Admin' or au.itemname='Attorney'", 'AND');
		$susr = $user->findAll($sq);
		$usere = new CaseUser;
		$sq = new CDbCriteria;
		$sq->join = " left join cases au on au.id = t.case_id";
		$sq->compare('au.id',$model->id);
		// $sq->compare('au.utype','<> staff');					
		$susr = $usere->findAll($sq);	
		foreach($susr as $s){
			if($s->utype=='staff'){
				$ur = User::model()->findByPk($s->user_id);
				$sselections .= $ur->profile->fullname.' & ';
			}else{
				$ur = User::model()->findByPk($s->user_id);
				$selections .= $ur->profile->fullname.' & ';
			}
		}
		$selections = substr($selections,0,-2);
		$sselections = substr($sselections,0,-2);
		// $selections= $susr;		
		// var_dump(count($selections));
		// if(isset($model->usr)){
			// if(count($model->usr)>=1){
				// $sselections = $model->usr;
				// $usere = new User;
				// $sq = new CDbCriteria;
				// $sq->join = " left join case_user au on au.user_id = t.id";
				// $sq->compare('au.case_id',$model->id);					
				// $sq->compare('au.utype','staff');					
				// $susr = $usere->findAll($sq);
				// $sselections= $susr;
				// var_dump(count($sselections));
			// }
		// }
		
		switch($model->case_type){
			case 'Contracts':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$cdd = $contract->find($cq);
				if(isset($cdd->id))
					$contract = Casecontract::model()->findByPk($cdd->id);				
				break;
			case 'Criminal Law':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$cri = $criminal->find($cq);
				if(isset($cri->id))
					$criminal = Criminallaw::model()->findByPk($cri->id);
				break;
			case 'Family Law':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$fam = $family->find($cq);
				if(isset($fam->id)){
					$family = Familylaw::model()->findByPk($fam->id);
					$cq = new CDbCriteria();
					$cq->compare('t.familylaw_id',$fam->id);
					$sp = $spouse->find($cq);
					// var_dump($fam->id);
					if(isset($sp->id))
						$spouse = Spouseinfo::model()->findByPk($sp->id);
					$ps = $marital->find($cq);
					// var_dump($ps->id);
					if(isset($ps->id))
						$marital = Maritalinfo::model()->findByPk($ps->id);
					$vd = new CDbCriteria;
					$vd->compare('t.familylaw_id',$fam->id);
					$childd = $child->findAll($vd);
				}
				break;
			case 'Immigration':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$mig = $migrate->find($cq);
				if(isset($mig->id))
					$migrate = Imigrationinfo::model()->findByPk($mig->id);
				break;
			case 'Probate':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$pro = $probate->find($cq);
				if(isset($pro->id))
					$probate = Probateinfo::model()->findByPk($pro->id);
				break;
			case 'Personal Injury':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$per = $personal->find($cq);
				if(isset($per->id)){
					$personal = Personalinjury::model()->findByPk($per->id);
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$per->id);
					$ine = $insurance->find($cq);
					if(isset($ine->id))
						$insurance = Insuranceca::model()->findByPk($ine->id);
				
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$personal->id);
					$hea = $health->find($cq);
					if(isset($hea->id))
						$health = Healthins::model()->findByPk($hea->id);
						
					$cq = new CDbCriteria();
					$cq->compare('t.personalinjury_id',$personal->id);
					// var_dump($personal->id);
					$heaa = $property->find($cq);
					if(isset($heaa->id))
						$property = Propertydamage::model()->findByPk($heaa->id);
				}
				$cq = new CDbCriteria();
				if(isset($personal->id)){
					$cq->compare('t.personalinjury_id',$personal->id);
					$medicals = $medical->findAll($cq);
				}
				$cq = new CDbCriteria();
				$cq->compare('t.personalinjury_id',$personal->id);
				$defendents = $defendent->findAll($cq);
				// if(isset($med)){
					// $meds = $medical->findAll($);
					// $medical = Medicalsprovider::model()->findByPk($med->id);
				// }
				break;
			case 'Real Estate':
				$cq = new CDbCriteria();
				$cq->compare('t.case_id',$id);
				$rea = $estate->find($cq);
				if(isset($rea->id)){
					$estate = Realestateinfo::model()->findByPk($rea->id);
					$fd = new CDbCriteria;
					$fd->compare('realestateinfo_id',$rea->id);
					$bs = $bsba->find($fd);
					if(isset($bs->id))
						$bsba = Bsbainfo::model()->findByPk($bs->id);
				}
				break;
			default:				
				break;
		}
		
		$cd = new CDbCriteria();
		$cd->compare('t.case_id',$id);
		$cI = $courtinfo->find($cd);
		if(isset($cI->id)){
			$courtinfo = Courtinfo::model()->findByPk($cI->id);
		}
		$cIi = $afap->find($cd);
		if(isset($cIi->id)){
			$afap = Afap::model()->findByPk($cIi->id);
			$cad = new CDbCriteria;
			$cad->compare('t.afap_id',$cIi->id);
			$cIa = $apattorney->findAll($cad);
			if(count($cIa)>=3){
				// $apattorney = Apattorney::model()->findByPk($cIa->id);
				$apattorneys = $cIa;
			}
		}
		
		$conI = $contract->find($cd);
		if(isset($conI->id)){
			$contract = Casecontract::model()->findByPk($conI->id);
		}
		$q = new CDbCriteria();
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';		
		$q->addCondition("(authassignment.itemname like 'Attorney' or authassignment.itemname like 'Admin')", 'AND');
		$rft = Yii::app()->user->firm_id;
		$q->compare('t.firm_id',$rft);
		$attorney = $user->findAll($q);                
		$q = new CDbCriteria();
		$q->compare('status','1');
		$q->join = 'LEFT JOIN authassignment ON authassignment.userid=t.id';
		$q->compare('authassignment.itemname','Staff');
		$q->compare('t.firm_id',Yii::app()->user->firm_id);
		$users = $paralegal = $user->findAll($q);
		if(isset($_POST['ajax']) && $_POST['ajax']==='casess-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}		
		$this->writeLog = false;
		$cid=$id;$apdataprovider='';
		$apdataprovider = new CActiveDataProvider('Adverseparty',array(
                        'criteria'=>array(
                            //'condition'=>'firm_id =\''.$user->firm_id.'\' and status=1 and (authassignment.itemname like \'%'.$type.'%\' or authassignment.itemname like \'%admin%\')',
                            // 'condition'=>'firm_id =\''.Yii::app()->user->firm_id.'\' and  case_id=\''.$_POST['cid'].'\'',
                            'condition'=>'t.case_id=\''.$id.'\'',
                            'order'=>'t.created DESC',
                            // 'join'=>'LEFT JOIN authassignment ON authassignment.userid = t.id',
                            // 'with'=>array('afaps'=>array('select'=>'afap.law_firm')),
                            //'with'=>array('authassignment'=>array('select'=>'authassignment.itemname')),
                            'with'=>array('afaps' ),        
                            // 'with'=>array('authassignment')
                        ),
                        'pagination'=>array(
                            'pageSize'=>6,
                        ), 
                    ));	
		$apar = new Adverseparty();
		// $cd = new CDbCriteria();
		// $cd->compare('t.case_id',$id);				
		// $aparties = $apar->findAll($cd);
		// $sql = "SELECT *, concat(last_name,', ',first_name) as fullname from adverseparty where id not in (SELECT adverseparty.id as counter FROM `adverseparty` inner join afap on afap.adverseparty_id=adverseparty.id WHERE 1) and adverseparty.case_id='".$id."'";
		$sql = "SELECT *, concat(last_name,', ',first_name) as fullname from adverseparty where adverseparty.case_id='".$id."'";
		$connection = Yii::app()->dynamicDb; 
		$command = $connection->createCommand($sql);
		$rowCount = $command->execute(); // execute the non-query SQL
		$aparties = $command->query(); // execute a query SQL
                        
		$isu=true;
                        
		$this->render('cp',array(
			'model'=>$model,			
			'cid'=>$cid,
			'contract'=>$contract,
			'probate'=>$probate,
			'criminal'=>$criminal,
			'apattorney'=>$apattorney,
			'apattorneys'=>$apattorneys,
			'apdataprovider'=>$apdataprovider,			
			'users'=>$users,
			'migrate'=>$migrate,			
			// 'ocapf'=>$ocapf,
			'estate'=>$estate,
			'personal'=>$personal,
                        'family'=>$family,
			'spouse'=>$spouse,
			'marital'=>$marital,
			'child'=>$child,
			'childd'=>$childd,
			'bsba'=>$bsba,
			'insurance'=>$insurance,
			'defendent'=>$defendent,
			'property'=>$property,
			'health'=>$health,
			'medical'=>$medical,
			'medicals'=>$medicals,
			'defendents'=>$defendents,
			'selections'=>$selections,
			'sselections'=>$sselections,
			'aat'=>$aat,
			'ocei'=>$ocei,
			'is_update'=>$isu,
			'aparty'=>$aparty,
			'afap'=>$afap,			
			'ocedi'=>$ocedi,
			// 'ocapfc'=>$ocapfc,
			'attorney'=>$attorney,
			'paralegal'=>$paralegal,
			'casead'=>$casead,
			'courtinfo'=>$courtinfo,
			'aparties'=>$aparties,
		));
	}
}   

