<?php

class AbilitytabController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Abilitytab;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Abilitytab']))
		{
			$model->attributes=$_POST['Abilitytab'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
                
                 $menu=new Menuitem; 
                    $fns=$menu->findAll('',array('item_id','label'));
                    
                    $auth=new Authitem;
                  $q=new CDbCriteria;
                  $q->compare('t.type',2);
                  $auths=$auth->findAll($q);
                  $abt=new Ability;
                 $abilities=$abt->findAll('',array('id','ability_name'));
                 
                    $this->render('create',array(
			'model'=>$model,
                        'fns'=>$fns,
                        'abilities'=>$abilities,
                        'auths'=>$auths,
		));
	}
        
        public function actionSetpermission()
        {
            $child=new Abilitytab;
            echo $_POST['permission'];
            if($_POST['permission']==0)
             Abilitytab::model()->deleteAll(array("condition"=>"menu_id='".$_POST['fun']."' and ability_id='".$_POST['id']."' and usertype='".$_POST['utype']."'"));
            if($_POST['permission']==1)
            {
               $child->usertype=$_POST['utype'];
               $child->menu_id=$_POST['fun'];
               $child->ability_id=$_POST['id'];
                $child->claim_status=0;
               $child->save();
               
            }
        }
 public function actionUpdateAjax()
        {
            
           // echo $_POST['Menuitem']['label'];
            $auth=new Authitem;
                  $q=new CDbCriteria;
                  $q->compare('t.type',2);
                  $auths=$auth->findAll($q);
                 $abt=new Ability;
                 $abilities=$abt->findAll('',array('id','ability_name'));
          $tbl=' <table>
                    <tr><td>User Types</td>
            ';
                if(count($abilities)>0)
                {
                    foreach($abilities as $ab)
                    {
                      $tbl.='<td>'.$ab->ability_name.'</td>';  
                        
                    }
                    
                }
                 $tbl.='</tr>';         
                        if(count($auths)>0)
                        {
                            $row=0;
                            foreach($auths as $ath)
                            {  
                               
                                
                              //  else {$t='<option value="1">Yes</option>';}
                            $tbl.='<tr>
                                   <td>'.$ath->name.'</td>';
                                   if(count($abilities)>0)
                                   {
                                   foreach($abilities as $ab)
                                   {
                                        $row++;
                                      $child=new Abilitytab;
                                        $q=new CDbCriteria;
                                        //$q->select=" count(t.parent) as tot";
                                        $q->condition ='t.menu_id="'.$_POST['Abilitytab']['menu_id'].'" and t.ability_id="'.$ab->id.'" and t.usertype="'.$ath->name.'"';
                                        $res=$child->findAll($q);
                                       // var_dump($q);
                                        if(count($res)>0)
                                        {
                                           $tot=1;
                                          $t='<input type="checkbox" name="ability_id[]" id="'.$row.$ab->id.'" value="'.$ab->id.'"  checked="checked" onclick="setvisibilty(this,\''.$ath->name.'\')" />';
                                        } 
                                        else
                                        {
                                            $t='<input type="checkbox" name="ability_id[]" id="'.$row.$ab->id.'" value="'.$ab->id.'" onclick="setvisibilty(this,\''.$ath->name.'\')" />'; 
                                        }
                                        $tbl.='<td>'.$t.'                                                           
                                       
                                   </td>';
                                   }
                                   }
                              
                               $tbl.='</tr>';
                            }
                            
                        }
                   
              $tbl.='</table>';
              
              echo $tbl;
                
        }
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Abilitytab']))
		{
			$model->attributes=$_POST['Abilitytab'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Abilitytab');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Abilitytab('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Abilitytab']))
			$model->attributes=$_GET['Abilitytab'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Abilitytab the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Abilitytab::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Abilitytab $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='abilitytab-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
