<?php

class CompanyController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','getcmp'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete','getcmp'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
 public function actionGetcmp(){
            
                $typ = new Company;
                $c = new CDbCriteria;
				$c->select='t.id,t.name';
                $c->join = 'left join companytype on companytype.id=t.type_id';
                $c->compare('t.type_id',$_POST['Company']['type_id']); 
                $data = $typ->findAll($c);
				
                $data=CHtml::listData($data,'id','name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select Company',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        public function actionGetusertype()
        {
            
             $utyp = new Usertype;
                $c = new CDbCriteria;
				$c->select='t.id,t.type';
                $c->join = 'left join companytype on companytype.id=t.companytype';
                $c->compare('t.companytype',$_POST['cmptype']); 
                $data = $utyp->findAll($c);
				
                $data=CHtml::listData($data,'type','type');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select Company',true);
				if($_POST['cmptype']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
        public function actionGetBranch()
        {
            
            $typ = new Company;
            $brc=new Branch;
                $c = new CDbCriteria;
				$c->select='t.id,t.branch_name';
                $c->join = 'left join company on company.id=t.company_id';
                $c->compare('t.company_id',$_POST['Company']['type_id']); 
                $data = $brc->findAll($c);
				
                $data=CHtml::listData($data,'id','branch_name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select Branch',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Company;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Company']))
		{
			$model->attributes=$_POST['Company'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
		$type=new Companytype;
		$types=$type->findAll('',array('id','type'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$this->render('create',array(
			'model'=>$model,
			'types'=>$types,
			'states'=>$states,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Company']))
		{
			$model->attributes=$_POST['Company'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Company');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Company('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Company']))
			$model->attributes=$_GET['Company'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Company the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Company::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Company $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='company-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
